/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * This type is used to describe an attachment, that has been embedded in a PDF file. The attachment itself may have connected document information, in that case the \&quot;document\&quot; element will be set.
 */
@Schema(description = "This type is used to describe an attachment, that has been embedded in a PDF file. The attachment itself may have connected document information, in that case the \"document\" element will be set.")
@JsonPropertyOrder({
  MetadataAttachment.JSON_PROPERTY_DESCRIPTION,
  MetadataAttachment.JSON_PROPERTY_DOCUMENT_TYPE,
  MetadataAttachment.JSON_PROPERTY_FOLDER_ID,
  MetadataAttachment.JSON_PROPERTY_MIME_TYPE,
  MetadataAttachment.JSON_PROPERTY_NAME,
  MetadataAttachment.JSON_PROPERTY_NUMBER,
  MetadataAttachment.JSON_PROPERTY_OBJECT_KEY,
  MetadataAttachment.JSON_PROPERTY_PAGE,
  MetadataAttachment.JSON_PROPERTY_SIZE
})
@JsonTypeName("Metadata_Attachment")

public class MetadataAttachment {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description = "";

  public static final String JSON_PROPERTY_DOCUMENT_TYPE = "documentType";
  private MetadataDocument documentType;

  public static final String JSON_PROPERTY_FOLDER_ID = "folderId";
  private Integer folderId = 0;

  public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
  private String mimeType = "";

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_NUMBER = "number";
  private Integer number = 0;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 0;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Double size = 0d;

  public MetadataAttachment() {
  }

  public MetadataAttachment description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * The file description of the attachment.
   * @return description
   **/
  @Nullable
  @Schema(name = "The file description of the attachment.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public MetadataAttachment documentType(MetadataDocument documentType) {
    
    this.documentType = documentType;
    return this;
  }

  /**
   * Get documentType
   * @return documentType
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataDocument getDocumentType() {
    return documentType;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentType(MetadataDocument documentType) {
    this.documentType = documentType;
  }


  public MetadataAttachment folderId(Integer folderId) {
    
    this.folderId = folderId;
    return this;
  }

  /**
   * The numeric ID of the folder containing the attachment. (This is only relevant for PDF Collections/Portfolios - otherwise attachments may not be arranged in a folder tree.)
   * @return folderId
   **/
  @Nullable
  @Schema(name = "The numeric ID of the folder containing the attachment. (This is only relevant for PDF Collections/Portfolios - otherwise attachments may not be arranged in a folder tree.)")
  @JsonProperty(JSON_PROPERTY_FOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFolderId() {
    return folderId;
  }


  @JsonProperty(JSON_PROPERTY_FOLDER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFolderId(Integer folderId) {
    this.folderId = folderId;
  }


  public MetadataAttachment mimeType(String mimeType) {
    
    this.mimeType = mimeType;
    return this;
  }

  /**
   * The attachment&#39;s MIME type.
   * @return mimeType
   **/
  @Nullable
  @Schema(name = "The attachment's MIME type.")
  @JsonProperty(JSON_PROPERTY_MIME_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMimeType() {
    return mimeType;
  }


  @JsonProperty(JSON_PROPERTY_MIME_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }


  public MetadataAttachment name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The file name of the attachment.
   * @return name
   **/
  @Nullable
  @Schema(name = "The file name of the attachment.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public MetadataAttachment number(Integer number) {
    
    this.number = number;
    return this;
  }

  /**
   * The position number of the attachment in the embedded files of the document.
   * minimum: 1
   * @return number
   **/
  @Nullable
  @Schema(name = "The position number of the attachment in the embedded files of the document.")
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(Integer number) {
    this.number = number;
  }


  public MetadataAttachment objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the attachment. **Info:** A PDF objects ID consists of two number, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the attachment. **Info:** A PDF objects ID consists of two number, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataAttachment page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * The page (if any), the attachment is placed on.
   * minimum: 0
   * @return page
   **/
  @Nullable
  @Schema(name = "The page (if any), the attachment is placed on.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public MetadataAttachment size(Double size) {
    
    this.size = size;
    return this;
  }

  /**
   * The byte size of the attachment.
   * minimum: 0
   * @return size
   **/
  @Nullable
  @Schema(name = "The byte size of the attachment.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSize(Double size) {
    this.size = size;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataAttachment metadataAttachment = (MetadataAttachment) o;
    return Objects.equals(this.description, metadataAttachment.description) &&
        Objects.equals(this.documentType, metadataAttachment.documentType) &&
        Objects.equals(this.folderId, metadataAttachment.folderId) &&
        Objects.equals(this.mimeType, metadataAttachment.mimeType) &&
        Objects.equals(this.name, metadataAttachment.name) &&
        Objects.equals(this.number, metadataAttachment.number) &&
        Objects.equals(this.objectKey, metadataAttachment.objectKey) &&
        Objects.equals(this.page, metadataAttachment.page) &&
        Objects.equals(this.size, metadataAttachment.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, documentType, folderId, mimeType, name, number, objectKey, page, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataAttachment {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    documentType: ").append(toIndentedString(documentType)).append("\n");
    sb.append("    folderId: ").append(toIndentedString(folderId)).append("\n");
    sb.append("    mimeType: ").append(toIndentedString(mimeType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
