/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines an image entry in the metadata for an image document.
 */
@Schema(description = "Defines an image entry in the metadata for an image document.")
@JsonPropertyOrder({
  DocumentMetadataImageEntry.JSON_PROPERTY_COLOR_DEPTH,
  DocumentMetadataImageEntry.JSON_PROPERTY_HEIGHT,
  DocumentMetadataImageEntry.JSON_PROPERTY_IS_ANIMATED,
  DocumentMetadataImageEntry.JSON_PROPERTY_METADATA,
  DocumentMetadataImageEntry.JSON_PROPERTY_ORIENTATION,
  DocumentMetadataImageEntry.JSON_PROPERTY_UNIT,
  DocumentMetadataImageEntry.JSON_PROPERTY_WIDTH,
  DocumentMetadataImageEntry.JSON_PROPERTY_X_RES,
  DocumentMetadataImageEntry.JSON_PROPERTY_Y_RES
})
@JsonTypeName("Document_MetadataImageEntry")

public class DocumentMetadataImageEntry {
  public static final String JSON_PROPERTY_COLOR_DEPTH = "colorDepth";
  private Integer colorDepth = 0;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Integer height = 0;

  public static final String JSON_PROPERTY_IS_ANIMATED = "isAnimated";
  private Boolean isAnimated = false;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, Map<String, String>> metadata = null;

  public static final String JSON_PROPERTY_ORIENTATION = "orientation";
  private DocumentMetadataImageOrientation orientation = DocumentMetadataImageOrientation.TOP_LEFT;

  public static final String JSON_PROPERTY_UNIT = "unit";
  private DocumentMetadataImageResolutionUnit unit = DocumentMetadataImageResolutionUnit.INCH;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Integer width = 0;

  public static final String JSON_PROPERTY_X_RES = "xRes";
  private Float xRes = 0f;

  public static final String JSON_PROPERTY_Y_RES = "yRes";
  private Float yRes = 0f;

  public DocumentMetadataImageEntry() {
  }

  @JsonCreator
  public DocumentMetadataImageEntry(
    @JsonProperty(JSON_PROPERTY_COLOR_DEPTH) Integer colorDepth, 
    @JsonProperty(JSON_PROPERTY_HEIGHT) Integer height, 
    @JsonProperty(JSON_PROPERTY_IS_ANIMATED) Boolean isAnimated, 
    @JsonProperty(JSON_PROPERTY_METADATA) Map<String, Map<String, String>> metadata, 
    @JsonProperty(JSON_PROPERTY_WIDTH) Integer width, 
    @JsonProperty(JSON_PROPERTY_X_RES) Float xRes, 
    @JsonProperty(JSON_PROPERTY_Y_RES) Float yRes
  ) {
    this();
    this.colorDepth = colorDepth;
    this.height = height;
    this.isAnimated = isAnimated;
    this.metadata = metadata;
    this.width = width;
    this.xRes = xRes;
    this.yRes = yRes;
  }

  /**
   * Color depth in bits
   * @return colorDepth
   **/
  @Nullable
  @Schema(name = "Color depth in bits")
  @JsonProperty(JSON_PROPERTY_COLOR_DEPTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getColorDepth() {
    return colorDepth;
  }




  /**
   * Image height
   * @return height
   **/
  @Nullable
  @Schema(name = "Image height")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHeight() {
    return height;
  }




  /**
   * True if it is an animated image
   * @return isAnimated
   **/
  @Nullable
  @Schema(name = "True if it is an animated image")
  @JsonProperty(JSON_PROPERTY_IS_ANIMATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsAnimated() {
    return isAnimated;
  }




  /**
   * Metadata dictionary of the image file format
   * @return metadata
   **/
  @Nullable
  @Schema(name = "Metadata dictionary of the image file format")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Map<String, String>> getMetadata() {
    return metadata;
  }




  public DocumentMetadataImageEntry orientation(DocumentMetadataImageOrientation orientation) {
    
    this.orientation = orientation;
    return this;
  }

  /**
   * Get orientation
   * @return orientation
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ORIENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocumentMetadataImageOrientation getOrientation() {
    return orientation;
  }




  public DocumentMetadataImageEntry unit(DocumentMetadataImageResolutionUnit unit) {
    
    this.unit = unit;
    return this;
  }

  /**
   * Get unit
   * @return unit
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocumentMetadataImageResolutionUnit getUnit() {
    return unit;
  }




  /**
   * Image width
   * @return width
   **/
  @Nullable
  @Schema(name = "Image width")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWidth() {
    return width;
  }




  /**
   * Horizontal resolution
   * @return xRes
   **/
  @Nullable
  @Schema(name = "Horizontal resolution")
  @JsonProperty(JSON_PROPERTY_X_RES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getxRes() {
    return xRes;
  }




  /**
   * Vertical resolution
   * @return yRes
   **/
  @Nullable
  @Schema(name = "Vertical resolution")
  @JsonProperty(JSON_PROPERTY_Y_RES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getyRes() {
    return yRes;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentMetadataImageEntry documentMetadataImageEntry = (DocumentMetadataImageEntry) o;
    return Objects.equals(this.colorDepth, documentMetadataImageEntry.colorDepth) &&
        Objects.equals(this.height, documentMetadataImageEntry.height) &&
        Objects.equals(this.isAnimated, documentMetadataImageEntry.isAnimated) &&
        Objects.equals(this.metadata, documentMetadataImageEntry.metadata) &&
        Objects.equals(this.orientation, documentMetadataImageEntry.orientation) &&
        Objects.equals(this.unit, documentMetadataImageEntry.unit) &&
        Objects.equals(this.width, documentMetadataImageEntry.width) &&
        Objects.equals(this.xRes, documentMetadataImageEntry.xRes) &&
        Objects.equals(this.yRes, documentMetadataImageEntry.yRes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(colorDepth, height, isAnimated, metadata, orientation, unit, width, xRes, yRes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentMetadataImageEntry {\n");
    sb.append("    colorDepth: ").append(toIndentedString(colorDepth)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    isAnimated: ").append(toIndentedString(isAnimated)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    orientation: ").append(toIndentedString(orientation)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    xRes: ").append(toIndentedString(xRes)).append("\n");
    sb.append("    yRes: ").append(toIndentedString(yRes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
