/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Contains the file information about a document in the document storage
 */
@Schema(description = "Contains the file information about a document in the document storage")
@JsonPropertyOrder({
  DocumentFile.JSON_PROPERTY_DOCUMENT_ID,
  DocumentFile.JSON_PROPERTY_ERROR,
  DocumentFile.JSON_PROPERTY_FILE_EXTENSION,
  DocumentFile.JSON_PROPERTY_FILE_LAST_MODIFIED,
  DocumentFile.JSON_PROPERTY_FILE_NAME,
  DocumentFile.JSON_PROPERTY_FILE_PATH,
  DocumentFile.JSON_PROPERTY_FILE_SIZE,
  DocumentFile.JSON_PROPERTY_FILE_TYPE_GROUPS,
  DocumentFile.JSON_PROPERTY_FILE_TYPE_ID,
  DocumentFile.JSON_PROPERTY_HISTORY_ID,
  DocumentFile.JSON_PROPERTY_IS_FILE_LOCKED,
  DocumentFile.JSON_PROPERTY_METADATA,
  DocumentFile.JSON_PROPERTY_MIME_TYPE,
  DocumentFile.JSON_PROPERTY_PARENT_DOCUMENT_ID,
  DocumentFile.JSON_PROPERTY_PASSWORD
})
@JsonTypeName("Document_File")

public class DocumentFile {
  public static final String JSON_PROPERTY_DOCUMENT_ID = "documentId";
  private String documentId = "";

  public static final String JSON_PROPERTY_ERROR = "error";
  private WebserviceException error;

  public static final String JSON_PROPERTY_FILE_EXTENSION = "fileExtension";
  private String fileExtension = "";

  public static final String JSON_PROPERTY_FILE_LAST_MODIFIED = "fileLastModified";
  private String fileLastModified = "";

  public static final String JSON_PROPERTY_FILE_NAME = "fileName";
  private String fileName = "";

  public static final String JSON_PROPERTY_FILE_PATH = "filePath";
  private String filePath = "";

  public static final String JSON_PROPERTY_FILE_SIZE = "fileSize";
  private Long fileSize = 0l;

  public static final String JSON_PROPERTY_FILE_TYPE_GROUPS = "fileTypeGroups";
  private String fileTypeGroups = "";

  public static final String JSON_PROPERTY_FILE_TYPE_ID = "fileTypeId";
  private Integer fileTypeId = 0;

  public static final String JSON_PROPERTY_HISTORY_ID = "historyId";
  private Integer historyId = 0;

  public static final String JSON_PROPERTY_IS_FILE_LOCKED = "isFileLocked";
  private Boolean isFileLocked = false;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private DocumentMetadata metadata;

  public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
  private String mimeType = "";

  public static final String JSON_PROPERTY_PARENT_DOCUMENT_ID = "parentDocumentId";
  private String parentDocumentId = "";

  public static final String JSON_PROPERTY_PASSWORD = "password";
  private DocumentPassword password;

  public DocumentFile() {
  }

  @JsonCreator
  public DocumentFile(
    @JsonProperty(JSON_PROPERTY_DOCUMENT_ID) String documentId, 
    @JsonProperty(JSON_PROPERTY_FILE_EXTENSION) String fileExtension, 
    @JsonProperty(JSON_PROPERTY_FILE_LAST_MODIFIED) String fileLastModified, 
    @JsonProperty(JSON_PROPERTY_FILE_PATH) String filePath, 
    @JsonProperty(JSON_PROPERTY_FILE_SIZE) Long fileSize, 
    @JsonProperty(JSON_PROPERTY_FILE_TYPE_GROUPS) String fileTypeGroups, 
    @JsonProperty(JSON_PROPERTY_FILE_TYPE_ID) Integer fileTypeId, 
    @JsonProperty(JSON_PROPERTY_HISTORY_ID) Integer historyId, 
    @JsonProperty(JSON_PROPERTY_IS_FILE_LOCKED) Boolean isFileLocked, 
    @JsonProperty(JSON_PROPERTY_MIME_TYPE) String mimeType, 
    @JsonProperty(JSON_PROPERTY_PARENT_DOCUMENT_ID) String parentDocumentId
  ) {
    this();
    this.documentId = documentId;
    this.fileExtension = fileExtension;
    this.fileLastModified = fileLastModified;
    this.filePath = filePath;
    this.fileSize = fileSize;
    this.fileTypeGroups = fileTypeGroups;
    this.fileTypeId = fileTypeId;
    this.historyId = historyId;
    this.isFileLocked = isFileLocked;
    this.mimeType = mimeType;
    this.parentDocumentId = parentDocumentId;
  }

  /**
   * Unique document id, which is required to access this document
   * @return documentId
   **/
  @NotNull
  @Schema(required = true, name = "Unique document id, which is required to access this document")
  @JsonProperty(JSON_PROPERTY_DOCUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDocumentId() {
    return documentId;
  }




  public DocumentFile error(WebserviceException error) {
    
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WebserviceException getError() {
    return error;
  }




  /**
   * File extension (without dot)
   * @return fileExtension
   **/
  @Nullable
  @Schema(name = "File extension (without dot)")
  @JsonProperty(JSON_PROPERTY_FILE_EXTENSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileExtension() {
    return fileExtension;
  }




  /**
   * Date of the last file modification
   * @return fileLastModified
   **/
  @Nullable
  @Schema(name = "Date of the last file modification")
  @JsonProperty(JSON_PROPERTY_FILE_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileLastModified() {
    return fileLastModified;
  }




  public DocumentFile fileName(String fileName) {
    
    this.fileName = fileName;
    return this;
  }

  /**
   * File name for the document (without extension)
   * @return fileName
   **/
  @Nullable
  @Schema(name = "File name for the document (without extension)")
  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileName() {
    return fileName;
  }


  @JsonProperty(JSON_PROPERTY_FILE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }


  /**
   * File path for the document
   * @return filePath
   **/
  @Nullable
  @Schema(name = "File path for the document")
  @JsonProperty(JSON_PROPERTY_FILE_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilePath() {
    return filePath;
  }




  /**
   * File size of the document (in bytes)
   * @return fileSize
   **/
  @Nullable
  @Schema(name = "File size of the document (in bytes)")
  @JsonProperty(JSON_PROPERTY_FILE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFileSize() {
    return fileSize;
  }




  /**
   * An internal unique text that describes the group to which the file belongs
   * @return fileTypeGroups
   **/
  @Nullable
  @Schema(name = "An internal unique text that describes the group to which the file belongs")
  @JsonProperty(JSON_PROPERTY_FILE_TYPE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFileTypeGroups() {
    return fileTypeGroups;
  }




  /**
   * An internal unique id for the file type
   * @return fileTypeId
   **/
  @Nullable
  @Schema(name = "An internal unique id for the file type")
  @JsonProperty(JSON_PROPERTY_FILE_TYPE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFileTypeId() {
    return fileTypeId;
  }




  /**
   * History id of the file entry
   * @return historyId
   **/
  @Nullable
  @Schema(name = "History id of the file entry")
  @JsonProperty(JSON_PROPERTY_HISTORY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHistoryId() {
    return historyId;
  }




  /**
   * If set the document is currently locked
   * @return isFileLocked
   **/
  @Nullable
  @Schema(name = "If set the document is currently locked")
  @JsonProperty(JSON_PROPERTY_IS_FILE_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsFileLocked() {
    return isFileLocked;
  }




  public DocumentFile metadata(DocumentMetadata metadata) {
    
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocumentMetadata getMetadata() {
    return metadata;
  }




  /**
   * Mime type of the document
   * @return mimeType
   **/
  @Nullable
  @Schema(name = "Mime type of the document")
  @JsonProperty(JSON_PROPERTY_MIME_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMimeType() {
    return mimeType;
  }




  /**
   * If available, the id of the parent document
   * @return parentDocumentId
   **/
  @Nullable
  @Schema(name = "If available, the id of the parent document")
  @JsonProperty(JSON_PROPERTY_PARENT_DOCUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParentDocumentId() {
    return parentDocumentId;
  }




  public DocumentFile password(DocumentPassword password) {
    
    this.password = password;
    return this;
  }

  /**
   * Get password
   * @return password
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocumentPassword getPassword() {
    return password;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentFile documentFile = (DocumentFile) o;
    return Objects.equals(this.documentId, documentFile.documentId) &&
        Objects.equals(this.error, documentFile.error) &&
        Objects.equals(this.fileExtension, documentFile.fileExtension) &&
        Objects.equals(this.fileLastModified, documentFile.fileLastModified) &&
        Objects.equals(this.fileName, documentFile.fileName) &&
        Objects.equals(this.filePath, documentFile.filePath) &&
        Objects.equals(this.fileSize, documentFile.fileSize) &&
        Objects.equals(this.fileTypeGroups, documentFile.fileTypeGroups) &&
        Objects.equals(this.fileTypeId, documentFile.fileTypeId) &&
        Objects.equals(this.historyId, documentFile.historyId) &&
        Objects.equals(this.isFileLocked, documentFile.isFileLocked) &&
        Objects.equals(this.metadata, documentFile.metadata) &&
        Objects.equals(this.mimeType, documentFile.mimeType) &&
        Objects.equals(this.parentDocumentId, documentFile.parentDocumentId) &&
        Objects.equals(this.password, documentFile.password);
  }

  @Override
  public int hashCode() {
    return Objects.hash(documentId, error, fileExtension, fileLastModified, fileName, filePath, fileSize, fileTypeGroups, fileTypeId, historyId, isFileLocked, metadata, mimeType, parentDocumentId, password);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentFile {\n");
    sb.append("    documentId: ").append(toIndentedString(documentId)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    fileExtension: ").append(toIndentedString(fileExtension)).append("\n");
    sb.append("    fileLastModified: ").append(toIndentedString(fileLastModified)).append("\n");
    sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
    sb.append("    filePath: ").append(toIndentedString(filePath)).append("\n");
    sb.append("    fileSize: ").append(toIndentedString(fileSize)).append("\n");
    sb.append("    fileTypeGroups: ").append(toIndentedString(fileTypeGroups)).append("\n");
    sb.append("    fileTypeId: ").append(toIndentedString(fileTypeId)).append("\n");
    sb.append("    historyId: ").append(toIndentedString(historyId)).append("\n");
    sb.append("    isFileLocked: ").append(toIndentedString(isFileLocked)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    mimeType: ").append(toIndentedString(mimeType)).append("\n");
    sb.append("    parentDocumentId: ").append(toIndentedString(parentDocumentId)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
