/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines a general authorization provider
 */
@Schema(description = "Defines a general authorization provider")
@JsonPropertyOrder({
  AuthProvider.JSON_PROPERTY_APPLICATION_ID,
  AuthProvider.JSON_PROPERTY_CLIENT_ID,
  AuthProvider.JSON_PROPERTY_DISPLAY_NAME,
  AuthProvider.JSON_PROPERTY_ID,
  AuthProvider.JSON_PROPERTY_LOGOUT,
  AuthProvider.JSON_PROPERTY_NAME,
  AuthProvider.JSON_PROPERTY_OIDC,
  AuthProvider.JSON_PROPERTY_SCOPE
})
@JsonTypeName("Auth_Provider")

public class AuthProvider {
  public static final String JSON_PROPERTY_APPLICATION_ID = "applicationId";
  private String applicationId = "";

  public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
  private String clientId = "";

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName = "";

  public static final String JSON_PROPERTY_ID = "id";
  private String id = "";

  public static final String JSON_PROPERTY_LOGOUT = "logout";
  private ServerConfigOAuthProviderLogout logout;

  /**
   * Gets or Sets name
   */
  public enum NameEnum {
    GENERIC(String.valueOf("generic")),
    
    AZURE_AD(String.valueOf("azureAd")),
    
    AUTH0(String.valueOf("auth0"));

    private String value;

    NameEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NameEnum fromValue(String value) {
      for (NameEnum b : NameEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NAME = "name";
  private NameEnum name = NameEnum.GENERIC;

  public static final String JSON_PROPERTY_OIDC = "oidc";
  private OAuthOIDCMetadata oidc;

  public static final String JSON_PROPERTY_SCOPE = "scope";
  private String scope = "";

  public AuthProvider() {
  }

  public AuthProvider applicationId(String applicationId) {
    
    this.applicationId = applicationId;
    return this;
  }

  /**
   * Get applicationId
   * @return applicationId
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_APPLICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApplicationId() {
    return applicationId;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationId(String applicationId) {
    this.applicationId = applicationId;
  }


  public AuthProvider clientId(String clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public AuthProvider displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

  /**
   * Get displayName
   * @return displayName
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public AuthProvider id(String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public AuthProvider logout(ServerConfigOAuthProviderLogout logout) {
    
    this.logout = logout;
    return this;
  }

  /**
   * Get logout
   * @return logout
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LOGOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ServerConfigOAuthProviderLogout getLogout() {
    return logout;
  }


  @JsonProperty(JSON_PROPERTY_LOGOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogout(ServerConfigOAuthProviderLogout logout) {
    this.logout = logout;
  }


  public AuthProvider name(NameEnum name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NameEnum getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(NameEnum name) {
    this.name = name;
  }


  public AuthProvider oidc(OAuthOIDCMetadata oidc) {
    
    this.oidc = oidc;
    return this;
  }

  /**
   * Get oidc
   * @return oidc
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OIDC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OAuthOIDCMetadata getOidc() {
    return oidc;
  }


  @JsonProperty(JSON_PROPERTY_OIDC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOidc(OAuthOIDCMetadata oidc) {
    this.oidc = oidc;
  }


  public AuthProvider scope(String scope) {
    
    this.scope = scope;
    return this;
  }

  /**
   * Get scope
   * @return scope
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScope() {
    return scope;
  }


  @JsonProperty(JSON_PROPERTY_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScope(String scope) {
    this.scope = scope;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthProvider authProvider = (AuthProvider) o;
    return Objects.equals(this.applicationId, authProvider.applicationId) &&
        Objects.equals(this.clientId, authProvider.clientId) &&
        Objects.equals(this.displayName, authProvider.displayName) &&
        Objects.equals(this.id, authProvider.id) &&
        Objects.equals(this.logout, authProvider.logout) &&
        Objects.equals(this.name, authProvider.name) &&
        Objects.equals(this.oidc, authProvider.oidc) &&
        Objects.equals(this.scope, authProvider.scope);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationId, clientId, displayName, id, logout, name, oidc, scope);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthProvider {\n");
    sb.append("    applicationId: ").append(toIndentedString(applicationId)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    logout: ").append(toIndentedString(logout)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    oidc: ").append(toIndentedString(oidc)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
