/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 10.0.1 (2025-05-09T12:58:50Z)
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Provides information about the operating system on which the server is running
 */
@Schema(description = "Provides information about the operating system on which the server is running")
@JsonPropertyOrder({
  AdminOsStatus.JSON_PROPERTY_CONTAINER,
  AdminOsStatus.JSON_PROPERTY_CPU_LOGICAL_PROCESSORS,
  AdminOsStatus.JSON_PROPERTY_MEMORY_COMMITTED_VIRTUAL_SIZE,
  AdminOsStatus.JSON_PROPERTY_MEMORY_FREE,
  AdminOsStatus.JSON_PROPERTY_MEMORY_FREE_SWAP_SIZE,
  AdminOsStatus.JSON_PROPERTY_MEMORY_TOTAL,
  AdminOsStatus.JSON_PROPERTY_MEMORY_TOTAL_SWAP_SIZE,
  AdminOsStatus.JSON_PROPERTY_OS_ARCHITECTURE,
  AdminOsStatus.JSON_PROPERTY_OS_NAME,
  AdminOsStatus.JSON_PROPERTY_OS_VERSION,
  AdminOsStatus.JSON_PROPERTY_PROCESS_CPU_LOAD,
  AdminOsStatus.JSON_PROPERTY_SYSTEM_LOAD_AVERAGE
})
@JsonTypeName("Admin_OsStatus")

public class AdminOsStatus {
  public static final String JSON_PROPERTY_CONTAINER = "container";
  private AdminOsStatusContainer container;

  public static final String JSON_PROPERTY_CPU_LOGICAL_PROCESSORS = "cpuLogicalProcessors";
  private Integer cpuLogicalProcessors = 0;

  public static final String JSON_PROPERTY_MEMORY_COMMITTED_VIRTUAL_SIZE = "memoryCommittedVirtualSize";
  private Long memoryCommittedVirtualSize = 0l;

  public static final String JSON_PROPERTY_MEMORY_FREE = "memoryFree";
  private Long memoryFree = 0l;

  public static final String JSON_PROPERTY_MEMORY_FREE_SWAP_SIZE = "memoryFreeSwapSize";
  private Long memoryFreeSwapSize = 0l;

  public static final String JSON_PROPERTY_MEMORY_TOTAL = "memoryTotal";
  private Long memoryTotal = 0l;

  public static final String JSON_PROPERTY_MEMORY_TOTAL_SWAP_SIZE = "memoryTotalSwapSize";
  private Long memoryTotalSwapSize = 0l;

  public static final String JSON_PROPERTY_OS_ARCHITECTURE = "osArchitecture";
  private String osArchitecture = "";

  public static final String JSON_PROPERTY_OS_NAME = "osName";
  private String osName = "";

  public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
  private String osVersion = "";

  public static final String JSON_PROPERTY_PROCESS_CPU_LOAD = "processCpuLoad";
  private Double processCpuLoad = 0d;

  public static final String JSON_PROPERTY_SYSTEM_LOAD_AVERAGE = "systemLoadAverage";
  private Double systemLoadAverage = 0d;

  public AdminOsStatus() {
  }

  public AdminOsStatus container(AdminOsStatusContainer container) {
    
    this.container = container;
    return this;
  }

  /**
   * Get container
   * @return container
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CONTAINER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdminOsStatusContainer getContainer() {
    return container;
  }


  @JsonProperty(JSON_PROPERTY_CONTAINER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContainer(AdminOsStatusContainer container) {
    this.container = container;
  }


  public AdminOsStatus cpuLogicalProcessors(Integer cpuLogicalProcessors) {
    
    this.cpuLogicalProcessors = cpuLogicalProcessors;
    return this;
  }

  /**
   * The number of logical processors available to the application
   * @return cpuLogicalProcessors
   **/
  @Nullable
  @Schema(name = "The number of logical processors available to the application")
  @JsonProperty(JSON_PROPERTY_CPU_LOGICAL_PROCESSORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCpuLogicalProcessors() {
    return cpuLogicalProcessors;
  }


  @JsonProperty(JSON_PROPERTY_CPU_LOGICAL_PROCESSORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCpuLogicalProcessors(Integer cpuLogicalProcessors) {
    this.cpuLogicalProcessors = cpuLogicalProcessors;
  }


  public AdminOsStatus memoryCommittedVirtualSize(Long memoryCommittedVirtualSize) {
    
    this.memoryCommittedVirtualSize = memoryCommittedVirtualSize;
    return this;
  }

  /**
   * The amount of virtual memory that is guaranteed to be available to the application in bytes
   * @return memoryCommittedVirtualSize
   **/
  @Nullable
  @Schema(name = "The amount of virtual memory that is guaranteed to be available to the application in bytes")
  @JsonProperty(JSON_PROPERTY_MEMORY_COMMITTED_VIRTUAL_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMemoryCommittedVirtualSize() {
    return memoryCommittedVirtualSize;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_COMMITTED_VIRTUAL_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryCommittedVirtualSize(Long memoryCommittedVirtualSize) {
    this.memoryCommittedVirtualSize = memoryCommittedVirtualSize;
  }


  public AdminOsStatus memoryFree(Long memoryFree) {
    
    this.memoryFree = memoryFree;
    return this;
  }

  /**
   * The amount of free memory in bytes
   * @return memoryFree
   **/
  @Nullable
  @Schema(name = "The amount of free memory in bytes")
  @JsonProperty(JSON_PROPERTY_MEMORY_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMemoryFree() {
    return memoryFree;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryFree(Long memoryFree) {
    this.memoryFree = memoryFree;
  }


  public AdminOsStatus memoryFreeSwapSize(Long memoryFreeSwapSize) {
    
    this.memoryFreeSwapSize = memoryFreeSwapSize;
    return this;
  }

  /**
   * The amount of free swap space in bytes
   * @return memoryFreeSwapSize
   **/
  @Nullable
  @Schema(name = "The amount of free swap space in bytes")
  @JsonProperty(JSON_PROPERTY_MEMORY_FREE_SWAP_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMemoryFreeSwapSize() {
    return memoryFreeSwapSize;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_FREE_SWAP_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryFreeSwapSize(Long memoryFreeSwapSize) {
    this.memoryFreeSwapSize = memoryFreeSwapSize;
  }


  public AdminOsStatus memoryTotal(Long memoryTotal) {
    
    this.memoryTotal = memoryTotal;
    return this;
  }

  /**
   * The total amount of memory in bytes
   * @return memoryTotal
   **/
  @Nullable
  @Schema(name = "The total amount of memory in bytes")
  @JsonProperty(JSON_PROPERTY_MEMORY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMemoryTotal() {
    return memoryTotal;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryTotal(Long memoryTotal) {
    this.memoryTotal = memoryTotal;
  }


  public AdminOsStatus memoryTotalSwapSize(Long memoryTotalSwapSize) {
    
    this.memoryTotalSwapSize = memoryTotalSwapSize;
    return this;
  }

  /**
   * The total amount of swap space in bytes
   * @return memoryTotalSwapSize
   **/
  @Nullable
  @Schema(name = "The total amount of swap space in bytes")
  @JsonProperty(JSON_PROPERTY_MEMORY_TOTAL_SWAP_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMemoryTotalSwapSize() {
    return memoryTotalSwapSize;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_TOTAL_SWAP_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryTotalSwapSize(Long memoryTotalSwapSize) {
    this.memoryTotalSwapSize = memoryTotalSwapSize;
  }


  public AdminOsStatus osArchitecture(String osArchitecture) {
    
    this.osArchitecture = osArchitecture;
    return this;
  }

  /**
   * The operating system´s architecture
   * @return osArchitecture
   **/
  @Nullable
  @Schema(name = "The operating system´s architecture")
  @JsonProperty(JSON_PROPERTY_OS_ARCHITECTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOsArchitecture() {
    return osArchitecture;
  }


  @JsonProperty(JSON_PROPERTY_OS_ARCHITECTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsArchitecture(String osArchitecture) {
    this.osArchitecture = osArchitecture;
  }


  public AdminOsStatus osName(String osName) {
    
    this.osName = osName;
    return this;
  }

  /**
   * The name of the operating system, the server is running on
   * @return osName
   **/
  @Nullable
  @Schema(name = "The name of the operating system, the server is running on")
  @JsonProperty(JSON_PROPERTY_OS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOsName() {
    return osName;
  }


  @JsonProperty(JSON_PROPERTY_OS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsName(String osName) {
    this.osName = osName;
  }


  public AdminOsStatus osVersion(String osVersion) {
    
    this.osVersion = osVersion;
    return this;
  }

  /**
   * The operating system´s version number
   * @return osVersion
   **/
  @Nullable
  @Schema(name = "The operating system´s version number")
  @JsonProperty(JSON_PROPERTY_OS_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOsVersion() {
    return osVersion;
  }


  @JsonProperty(JSON_PROPERTY_OS_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsVersion(String osVersion) {
    this.osVersion = osVersion;
  }


  public AdminOsStatus processCpuLoad(Double processCpuLoad) {
    
    this.processCpuLoad = processCpuLoad;
    return this;
  }

  /**
   * The recent CPU usage of the JVM with a value between 0.0 and 1.0 (a value of 1.0 means that threads were actively executed on all CPUs)
   * @return processCpuLoad
   **/
  @Nullable
  @Schema(name = "The recent CPU usage of the JVM with a value between 0.0 and 1.0 (a value of 1.0 means that threads were actively executed on all CPUs)")
  @JsonProperty(JSON_PROPERTY_PROCESS_CPU_LOAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getProcessCpuLoad() {
    return processCpuLoad;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_CPU_LOAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessCpuLoad(Double processCpuLoad) {
    this.processCpuLoad = processCpuLoad;
  }


  public AdminOsStatus systemLoadAverage(Double systemLoadAverage) {
    
    this.systemLoadAverage = systemLoadAverage;
    return this;
  }

  /**
   * The system load average for the last minute (or a negative value if not available)
   * @return systemLoadAverage
   **/
  @Nullable
  @Schema(name = "The system load average for the last minute (or a negative value if not available)")
  @JsonProperty(JSON_PROPERTY_SYSTEM_LOAD_AVERAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getSystemLoadAverage() {
    return systemLoadAverage;
  }


  @JsonProperty(JSON_PROPERTY_SYSTEM_LOAD_AVERAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSystemLoadAverage(Double systemLoadAverage) {
    this.systemLoadAverage = systemLoadAverage;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminOsStatus adminOsStatus = (AdminOsStatus) o;
    return Objects.equals(this.container, adminOsStatus.container) &&
        Objects.equals(this.cpuLogicalProcessors, adminOsStatus.cpuLogicalProcessors) &&
        Objects.equals(this.memoryCommittedVirtualSize, adminOsStatus.memoryCommittedVirtualSize) &&
        Objects.equals(this.memoryFree, adminOsStatus.memoryFree) &&
        Objects.equals(this.memoryFreeSwapSize, adminOsStatus.memoryFreeSwapSize) &&
        Objects.equals(this.memoryTotal, adminOsStatus.memoryTotal) &&
        Objects.equals(this.memoryTotalSwapSize, adminOsStatus.memoryTotalSwapSize) &&
        Objects.equals(this.osArchitecture, adminOsStatus.osArchitecture) &&
        Objects.equals(this.osName, adminOsStatus.osName) &&
        Objects.equals(this.osVersion, adminOsStatus.osVersion) &&
        Objects.equals(this.processCpuLoad, adminOsStatus.processCpuLoad) &&
        Objects.equals(this.systemLoadAverage, adminOsStatus.systemLoadAverage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(container, cpuLogicalProcessors, memoryCommittedVirtualSize, memoryFree, memoryFreeSwapSize, memoryTotal, memoryTotalSwapSize, osArchitecture, osName, osVersion, processCpuLoad, systemLoadAverage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminOsStatus {\n");
    sb.append("    container: ").append(toIndentedString(container)).append("\n");
    sb.append("    cpuLogicalProcessors: ").append(toIndentedString(cpuLogicalProcessors)).append("\n");
    sb.append("    memoryCommittedVirtualSize: ").append(toIndentedString(memoryCommittedVirtualSize)).append("\n");
    sb.append("    memoryFree: ").append(toIndentedString(memoryFree)).append("\n");
    sb.append("    memoryFreeSwapSize: ").append(toIndentedString(memoryFreeSwapSize)).append("\n");
    sb.append("    memoryTotal: ").append(toIndentedString(memoryTotal)).append("\n");
    sb.append("    memoryTotalSwapSize: ").append(toIndentedString(memoryTotalSwapSize)).append("\n");
    sb.append("    osArchitecture: ").append(toIndentedString(osArchitecture)).append("\n");
    sb.append("    osName: ").append(toIndentedString(osName)).append("\n");
    sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
    sb.append("    processCpuLoad: ").append(toIndentedString(processCpuLoad)).append("\n");
    sb.append("    systemLoadAverage: ").append(toIndentedString(systemLoadAverage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
