
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Changes the reply state of the selected annotation.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ReplyStateRelationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ReplyStateRelationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/extraction/info}BaseRelationType">
 *       <attribute name="state" type="{http://schema.webpdf.de/1.0/extraction/info}ReplyStateType" default="none" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReplyStateRelationType")
public class ReplyStateRelationType
    extends BaseRelationType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The set reply state of the commented annotation.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;accepted = The user agrees with the change.&lt;/li&gt;&lt;li&gt;rejected = The user disagrees with the change.&lt;/li&gt;&lt;li&gt;cancelled = The change has been cancelled.&lt;/li&gt;&lt;li&gt;completed = The change has been completed.&lt;/li&gt;&lt;li&gt;none = The user did not set a state.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "state")
    protected ReplyStateType state;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The set reply state of the commented annotation.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;accepted = The user agrees with the change.&lt;/li&gt;&lt;li&gt;rejected = The user disagrees with the change.&lt;/li&gt;&lt;li&gt;cancelled = The change has been cancelled.&lt;/li&gt;&lt;li&gt;completed = The change has been completed.&lt;/li&gt;&lt;li&gt;none = The user did not set a state.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ReplyStateType }
     *     
     */
    public ReplyStateType getState() {
        if (state == null) {
            return ReplyStateType.NONE;
        } else {
            return state;
        }
    }

    /**
     * Sets the value of the state property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReplyStateType }
     *     
     * @see #getState()
     */
    public void setState(ReplyStateType value) {
        this.state = value;
    }

}
