
package net.webpdf.parameter.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns="http://schema.webpdf.de/1.0/extraction/info" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the visible box, when displaying the document.&#13;
 *                     &lt;ul&gt;&lt;li&gt;media_box = The page's physical dimensions.&lt;/li&gt;&lt;li&gt;crop_box = The visible (printable) page area.&lt;/li&gt;&lt;li&gt;bleed_box = Untrimmed content position on the page (content dimensions plus trim box).&lt;/li&gt;&lt;li&gt;trim_box = Trimmed content position on the page (final content dimensions).&lt;/li&gt;&lt;li&gt;art_box = Position for special page content (images).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for BoxSelectionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="BoxSelectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="mediaBox"/>
 *     <enumeration value="cropBox"/>
 *     <enumeration value="bleedBox"/>
 *     <enumeration value="trimBox"/>
 *     <enumeration value="artBox"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BoxSelectionType")
@XmlEnum
public enum BoxSelectionType {

    @XmlEnumValue("mediaBox")
    MEDIA_BOX("mediaBox"),
    @XmlEnumValue("cropBox")
    CROP_BOX("cropBox"),
    @XmlEnumValue("bleedBox")
    BLEED_BOX("bleedBox"),
    @XmlEnumValue("trimBox")
    TRIM_BOX("trimBox"),
    @XmlEnumValue("artBox")
    ART_BOX("artBox");
    private final String value;

    BoxSelectionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static BoxSelectionType fromValue(String v) {
        for (BoxSelectionType c: BoxSelectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
