/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.soap.documents;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.documents.AbstractDocument;
import net.webpdf.wsclient.session.soap.documents.SoapDocument;
import net.webpdf.wsclient.session.soap.documents.datasource.BinaryDataSource;
import net.webpdf.wsclient.session.soap.documents.datasource.PathDataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoapWebServiceDocument
extends AbstractDocument
implements SoapDocument {
    @Nullable
    private final DataSource source;
    @Nullable
    private DataHandler result;

    public SoapWebServiceDocument() {
        super(null);
        this.source = null;
    }

    public SoapWebServiceDocument(@NotNull InputStream source) throws ResultException {
        super(null);
        try {
            this.source = new BinaryDataSource(source);
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_SOURCE_DOCUMENT, ex);
        }
    }

    public SoapWebServiceDocument(@NotNull URI source) throws ResultException {
        super(source);
        try {
            if (!this.isFileSource()) {
                throw new ClientResultException(Error.INVALID_SOURCE_DOCUMENT);
            }
            this.source = new PathDataSource(new File(source).toPath());
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_SOURCE_DOCUMENT, ex);
        }
    }

    public SoapWebServiceDocument(@NotNull File source) throws ResultException {
        super(source.toURI());
        try {
            this.source = new PathDataSource(source.toPath());
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.INVALID_SOURCE_DOCUMENT, ex);
        }
    }

    @Override
    @Nullable
    public DataHandler getSourceDataHandler() {
        return this.source != null ? new DataHandler(this.source) : null;
    }

    @Override
    public void setResult(@Nullable DataHandler result) {
        this.result = result;
    }

    @Override
    @Nullable
    public DataHandler getResult() {
        return this.result;
    }

    @Override
    public void writeResult(@NotNull OutputStream target) throws ResultException {
        if (this.result == null) {
            throw new ClientResultException(Error.SOAP_EXECUTION, new IOException("No document content available"));
        }
        try {
            this.result.writeTo(target);
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.SOAP_EXECUTION, ex);
        }
    }

    @Override
    public void writeResult(@NotNull File target) throws ResultException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            this.writeResult(outputStream);
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.SOAP_EXECUTION, ex);
        }
    }

    @Override
    public void close() throws ResultException {
        try {
            if (this.source instanceof Closeable) {
                ((Closeable)this.source).close();
            }
            if (this.result instanceof Closeable) {
                ((Closeable)this.result).close();
                this.result = null;
            }
        }
        catch (IOException ex) {
            throw new ClientResultException(Error.FAILED_TO_CLOSE_DATA_SOURCE, ex);
        }
    }
}

