/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the error object that is returned in the response to a REST web service call when an error has occurred.  * The error message will summarize why the execution of the selected operation has not been possible or failed and will possibly contain further instructions. * This does not necessarily indicate an error of the server and possibly rather indicates, that the intended operation is not fit to be executed for the given document, using the given parameters. (e.g. accessing a password protected document without required decryption material) * Should the error message not be helpful, please refer to the user manual and search for the given error code there, for a more detailed description. * When contacting our support, please provide the hereby given error code, stacktrace and optimally the document and parameters, that lead to this error object being returned.")
@JsonPropertyOrder(value={"errorCode", "errorMessage", "stackTrace"})
@JsonTypeName(value="Webservice_Exception")
public class WebserviceException {
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private Integer errorCode = 0;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private String errorMessage = "";
    public static final String JSON_PROPERTY_STACK_TRACE = "stackTrace";
    private String stackTrace = "";

    public WebserviceException() {
    }

    @JsonCreator
    public WebserviceException(@JsonProperty(value="errorCode") Integer errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="stackTrace") String stackTrace) {
        this();
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.stackTrace = stackTrace;
    }

    @Schema(example="-7", required=true, name="The error code (use this error code to find further information in the user manual).")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public Integer getErrorCode() {
        return this.errorCode;
    }

    @Schema(example="Unable to read pdf file content", required=true, name="The descriptive error message indicating why the operation failed or cannot be executed. This may also contain further hints to solve the problem.")
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Schema(example="... <Java stacktrace as string> ...", name="The Java stack trace relevant to the exception analysis.")
    @JsonProperty(value="stackTrace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebserviceException webserviceException = (WebserviceException)o;
        return Objects.equals(this.errorCode, webserviceException.errorCode) && Objects.equals(this.errorMessage, webserviceException.errorMessage) && Objects.equals(this.stackTrace, webserviceException.stackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage, this.stackTrace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebserviceException {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    stackTrace: ").append(this.toIndentedString(this.stackTrace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

