/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Configures an [APR Lifecycle Listener](https://tomcat.apache.org/tomcat-10.0-doc/config/listeners.html) for the underlying tomcat server.")
@JsonPropertyOrder(value={"enabled", "fipsMode", "sslEngine", "sslRandomSeed", "useAprConnector", "useOpenSSL"})
@JsonTypeName(value="ServerConfig_Apr")
public class ServerConfigApr {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_FIPS_MODE = "fipsMode";
    private String fipsMode = "off";
    public static final String JSON_PROPERTY_SSL_ENGINE = "sslEngine";
    private String sslEngine = "on";
    public static final String JSON_PROPERTY_SSL_RANDOM_SEED = "sslRandomSeed";
    private String sslRandomSeed = "builtin";
    public static final String JSON_PROPERTY_USE_APR_CONNECTOR = "useAprConnector";
    private Boolean useAprConnector = false;
    public static final String JSON_PROPERTY_USE_OPEN_S_S_L = "useOpenSSL";
    private Boolean useOpenSSL = true;

    public ServerConfigApr enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="When set to true, the APR Lifecycle Listener shall be activated.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ServerConfigApr fipsMode(String fipsMode) {
        this.fipsMode = fipsMode;
        return this;
    }

    @Schema(name="Set this to \"on\" to request SSL to operate in FIPS (Federal Information Processing Standards) mode.  *   \"enter\" to force OpenSSL to enter FIPS mode. *   \"require\" to require that OpenSSL already operates in FIPS mode. *   \"off\" to disable the FIPS mode.  For this to take effect \"useOpenSSL\" must be set to true. (It is highly recommended to refer to https://tomcat.apache.org/tomcat-10.0-doc/config/listeners.html)")
    @JsonProperty(value="fipsMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFipsMode() {
        return this.fipsMode;
    }

    @JsonProperty(value="fipsMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFipsMode(String fipsMode) {
        this.fipsMode = fipsMode;
    }

    public ServerConfigApr sslEngine(String sslEngine) {
        this.sslEngine = sslEngine;
        return this;
    }

    @Schema(name="Selects the [SSL](https://www.openssl.org/) engine to use, possible values are \"off\" (do not use SSL) \"on\" (use SSL without specifying the engine).")
    @JsonProperty(value="sslEngine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSslEngine() {
        return this.sslEngine;
    }

    @JsonProperty(value="sslEngine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSslEngine(String sslEngine) {
        this.sslEngine = sslEngine;
    }

    public ServerConfigApr sslRandomSeed(String sslRandomSeed) {
        this.sslRandomSeed = sslRandomSeed;
        return this;
    }

    @Schema(name="An entropy source to seed the SSL engine's random number generation with. To allow for quicker start time, set this to \"/dev/urandom\".")
    @JsonProperty(value="sslRandomSeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSslRandomSeed() {
        return this.sslRandomSeed;
    }

    @JsonProperty(value="sslRandomSeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSslRandomSeed(String sslRandomSeed) {
        this.sslRandomSeed = sslRandomSeed;
    }

    public ServerConfigApr useAprConnector(Boolean useAprConnector) {
        this.useAprConnector = useAprConnector;
        return this;
    }

    @Schema(name="This field currently is unused.")
    @JsonProperty(value="useAprConnector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseAprConnector() {
        return this.useAprConnector;
    }

    @JsonProperty(value="useAprConnector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseAprConnector(Boolean useAprConnector) {
        this.useAprConnector = useAprConnector;
    }

    public ServerConfigApr useOpenSSL(Boolean useOpenSSL) {
        this.useOpenSSL = useOpenSSL;
        return this;
    }

    @Schema(name="When set to true this activates the usage of OpenSSL for NIO and NIO2 connectors.")
    @JsonProperty(value="useOpenSSL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseOpenSSL() {
        return this.useOpenSSL;
    }

    @JsonProperty(value="useOpenSSL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseOpenSSL(Boolean useOpenSSL) {
        this.useOpenSSL = useOpenSSL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigApr serverConfigApr = (ServerConfigApr)o;
        return Objects.equals(this.enabled, serverConfigApr.enabled) && Objects.equals(this.fipsMode, serverConfigApr.fipsMode) && Objects.equals(this.sslEngine, serverConfigApr.sslEngine) && Objects.equals(this.sslRandomSeed, serverConfigApr.sslRandomSeed) && Objects.equals(this.useAprConnector, serverConfigApr.useAprConnector) && Objects.equals(this.useOpenSSL, serverConfigApr.useOpenSSL);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.fipsMode, this.sslEngine, this.sslRandomSeed, this.useAprConnector, this.useOpenSSL);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigApr {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    fipsMode: ").append(this.toIndentedString(this.fipsMode)).append("\n");
        sb.append("    sslEngine: ").append(this.toIndentedString(this.sslEngine)).append("\n");
        sb.append("    sslRandomSeed: ").append(this.toIndentedString(this.sslRandomSeed)).append("\n");
        sb.append("    useAprConnector: ").append(this.toIndentedString(this.useAprConnector)).append("\n");
        sb.append("    useOpenSSL: ").append(this.toIndentedString(this.useOpenSSL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

