/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="This element defines a file necessary for the transformation, which is passed \"Base64 encoded\". This element can be used with `<resources>` or `<visualization>`. In the case of `<resources>`, this is a file that defines, for example, an XLST stylesheet or a CSS resource. In the case of an X invoice and the parent `<visualization>` it defines a file (XLST stylesheet) which defines a different layout for the PDF output.")
@JsonPropertyOrder(value={"fileName", "format", "source", "uri", "value"})
@JsonTypeName(value="Operation_XslTransformationFile")
public class OperationXslTransformationFile {
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format = FormatEnum.XSLT;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.VALUE;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private byte[] value;

    public OperationXslTransformationFile fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="The filename of the file. This is the name under which the resource can be found again and is especially important for resources that are referenced from other files passed here via this name. (For example, the name of a CSS stylesheet that is referenced by name from an XSLT stylesheet).")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public OperationXslTransformationFile format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Schema(name="The type of the resource passed  *   xlst = An XSLT stylesheet to be used for the transformation. *   other = Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.  **Important:** The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format \"xlst\" are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public OperationXslTransformationFile source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Schema(name="Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public OperationXslTransformationFile uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(name="The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public OperationXslTransformationFile value(byte[] value) {
        this.value = value;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationXslTransformationFile operationXslTransformationFile = (OperationXslTransformationFile)o;
        return Objects.equals(this.fileName, operationXslTransformationFile.fileName) && Objects.equals((Object)this.format, (Object)operationXslTransformationFile.format) && Objects.equals((Object)this.source, (Object)operationXslTransformationFile.source) && Objects.equals(this.uri, operationXslTransformationFile.uri) && Arrays.equals(this.value, operationXslTransformationFile.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileName, this.format, this.source, this.uri, Arrays.hashCode(this.value)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationXslTransformationFile {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        VALUE(String.valueOf("value")),
        URI(String.valueOf("uri"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FormatEnum {
        XSLT(String.valueOf("xslt")),
        OTHER(String.valueOf("other"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

