/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@JsonPropertyOrder(value={"fromText", "protocol", "withoutProtocol"})
@JsonTypeName(value="Operation_TextExtractionLinks")
public class OperationTextExtractionLinks {
    public static final String JSON_PROPERTY_FROM_TEXT = "fromText";
    private Boolean fromText = false;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private String protocol = "";
    public static final String JSON_PROPERTY_WITHOUT_PROTOCOL = "withoutProtocol";
    private Boolean withoutProtocol = true;

    public OperationTextExtractionLinks fromText(Boolean fromText) {
        this.fromText = fromText;
        return this;
    }

    @Schema(name="Advanced mode for extracting links When using this mode, links will not be extracted from annotations, but will instead be extracted directly from the text. This means that links that are not found in standard mode can be found with this advanced mode, provided that they are present in the form of text.")
    @JsonProperty(value="fromText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFromText() {
        return this.fromText;
    }

    @JsonProperty(value="fromText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFromText(Boolean fromText) {
        this.fromText = fromText;
    }

    public OperationTextExtractionLinks protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Schema(name="Provides the option of filtering the links being extracted by protocol. If multiple protocols are specified, they need to be separated with commas (e.g., \"http,https,ftp\"). The following values are valid: \"http\",\"https\",\"ftp\", \"telnet\",\"mailto\", \"file\", \"nntp\", and \"notes\".")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public OperationTextExtractionLinks withoutProtocol(Boolean withoutProtocol) {
        this.withoutProtocol = withoutProtocol;
        return this;
    }

    @Schema(name="When enabled, incomplete URLs from which the protocol information is missing will be extracted as well when extracting links from text. This would apply to the following examples, for instance:  *   \"www.webpdf.de\" - There is no protocol information. If the option is enabled and \"http\" links are searched for, the link will be extracted. *   \"ftp.softvision.de\" - There is no protocol information here either. If the option is enabled and \"ftp\" links are searched for, the link will be extracted.")
    @JsonProperty(value="withoutProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getWithoutProtocol() {
        return this.withoutProtocol;
    }

    @JsonProperty(value="withoutProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWithoutProtocol(Boolean withoutProtocol) {
        this.withoutProtocol = withoutProtocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTextExtractionLinks operationTextExtractionLinks = (OperationTextExtractionLinks)o;
        return Objects.equals(this.fromText, operationTextExtractionLinks.fromText) && Objects.equals(this.protocol, operationTextExtractionLinks.protocol) && Objects.equals(this.withoutProtocol, operationTextExtractionLinks.withoutProtocol);
    }

    public int hashCode() {
        return Objects.hash(this.fromText, this.protocol, this.withoutProtocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTextExtractionLinks {\n");
        sb.append("    fromText: ").append(this.toIndentedString(this.fromText)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("    withoutProtocol: ").append(this.toIndentedString(this.withoutProtocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

