/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPortfolioFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define an individual document that should be added to the portfolio. This element can be used multiple times if you want to add multiple documents.")
@JsonPropertyOrder(value={"creator", "data", "fileName", "mimeType", "path"})
@JsonTypeName(value="Operation_PortfolioFile")
public class OperationPortfolioFile {
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationPortfolioFileData data;
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
    private String mimeType = "";
    public static final String JSON_PROPERTY_PATH = "path";
    private String path = "";

    public OperationPortfolioFile creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="The creator of the portfolio entry.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationPortfolioFile data(OperationPortfolioFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationPortfolioFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationPortfolioFileData data) {
        this.data = data;
    }

    public OperationPortfolioFile fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="Defines the name under which the document is stored in the portfolio.")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public OperationPortfolioFile mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Schema(name="The MIME type of the portfolio entry.")
    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public OperationPortfolioFile path(String path) {
        this.path = path;
        return this;
    }

    @Schema(name="Defines the path/folder where the document is stored in the portfolio.  **Important:** A portfolio path is defined by the \"/\" separated nested folder names.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPortfolioFile operationPortfolioFile = (OperationPortfolioFile)o;
        return Objects.equals(this.creator, operationPortfolioFile.creator) && Objects.equals(this.data, operationPortfolioFile.data) && Objects.equals(this.fileName, operationPortfolioFile.fileName) && Objects.equals(this.mimeType, operationPortfolioFile.mimeType) && Objects.equals(this.path, operationPortfolioFile.path);
    }

    public int hashCode() {
        return Objects.hash(this.creator, this.data, this.fileName, this.mimeType, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPortfolioFile {\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

