/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationKeyPair;
import org.jetbrains.annotations.Nullable;

@Schema(description="The `password` element can be used to set the user and owner passwords or certificates for the PDF document which are needed if the PDF document is protected. For example, if a protected PDF document is to be edited with the web service, then these settings can be used to provide the password or certificates for access.")
@JsonPropertyOrder(value={"keyPair", "open", "permission"})
@JsonTypeName(value="Operation_PdfPassword")
public class OperationPdfPassword {
    public static final String JSON_PROPERTY_KEY_PAIR = "keyPair";
    private OperationKeyPair keyPair;
    public static final String JSON_PROPERTY_OPEN = "open";
    private String open = "";
    public static final String JSON_PROPERTY_PERMISSION = "permission";
    private String permission = "";

    public OperationPdfPassword keyPair(OperationKeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="keyPair")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationKeyPair getKeyPair() {
        return this.keyPair;
    }

    @JsonProperty(value="keyPair")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyPair(OperationKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public OperationPdfPassword open(String open) {
        this.open = open;
        return this;
    }

    @Schema(name="A password that is required to open the document. If the provided PDF document is protected in such a way that a password (user password) is required to read the document, the corresponding password must also be passed. Without this password it is not possible to edit the document with the web service, because it cannot be read.")
    @JsonProperty(value="open")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOpen() {
        return this.open;
    }

    @JsonProperty(value="open")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpen(String open) {
        this.open = open;
    }

    public OperationPdfPassword permission(String permission) {
        this.permission = permission;
        return this;
    }

    @Schema(name="A password that allows \"editing access\" to the document. If the provided PDF document is password protected and the web service operation is to edit the document, then the appropriate password (owner password) must be provided to unlock the document.")
    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @JsonProperty(value="permission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPdfPassword operationPdfPassword = (OperationPdfPassword)o;
        return Objects.equals(this.keyPair, operationPdfPassword.keyPair) && Objects.equals(this.open, operationPdfPassword.open) && Objects.equals(this.permission, operationPdfPassword.permission);
    }

    public int hashCode() {
        return Objects.hash(this.keyPair, this.open, this.permission);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPdfPassword {\n");
        sb.append("    keyPair: ").append(this.toIndentedString(this.keyPair)).append("\n");
        sb.append("    open: ").append(this.toIndentedString(this.open)).append("\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

