/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains the BASE64 encoded file that should be inserted or appended. The \"format\" attribute is used to define whether the file is a single PDF document, a ZIP file containing multiple PDF documents or a list of documents references by ID. If a ZIP archive is passed as the source document of the web service request, this parameter can be omitted. The parameter \"sourceIsZip\" must be set to \"true\" in that case.")
@JsonPropertyOrder(value={"format", "outlineName", "source", "uri", "value"})
@JsonTypeName(value="Operation_MergeFileData")
public class OperationMergeFileData {
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format = FormatEnum.PDF;
    public static final String JSON_PROPERTY_OUTLINE_NAME = "outlineName";
    private String outlineName = "";
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.VALUE;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private byte[] value;

    public OperationMergeFileData format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Schema(name="Specifies the format how to pass the documents to be used for merging.  *   pdf = A single PDF file *   zip = It is a ZIP file that contains one or more PDF documents. *   id = It is a semicolon separated list of document ID's referencing documents already on the server (REST API only).  **Important:** The \"id\" parameter can be used only with REST API. Each document that has been uploaded to the server via REST API has a unique ID. This ID can be used to reference the document. In the content of the \"data\" element, the list is passed as BASE64 content. Example for two documents:  *   List of documents: 3bde686a47284a2da3bfce62bd6bb8bd;f5c2b314d0c74fd0878d1f4ca310b0ad *   BASE64 encoded: M2JkZTY4NmE0NzI4NGEyZGEzYmZjZTYyYmQ2YmI4YmQ7ZjVjMmIzMTRkMGM3NGZkMDg3OGQxZjRjYTMxMGIwYWQ=")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public OperationMergeFileData outlineName(String outlineName) {
        this.outlineName = outlineName;
        return this;
    }

    @Schema(name="Used to define the base path that should be used for outline nodes of the appended document. This parameter can contain a slash separated path and should ideally end with the name of the document (\"A/B/filename\"). If this parameter is not set, all outlines will be appended to the root outline node.")
    @JsonProperty(value="outlineName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOutlineName() {
        return this.outlineName;
    }

    @JsonProperty(value="outlineName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutlineName(String outlineName) {
        this.outlineName = outlineName;
    }

    public OperationMergeFileData source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Schema(name="Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public OperationMergeFileData uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(name="The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public OperationMergeFileData value(byte[] value) {
        this.value = value;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationMergeFileData operationMergeFileData = (OperationMergeFileData)o;
        return Objects.equals((Object)this.format, (Object)operationMergeFileData.format) && Objects.equals(this.outlineName, operationMergeFileData.outlineName) && Objects.equals((Object)this.source, (Object)operationMergeFileData.source) && Objects.equals(this.uri, operationMergeFileData.uri) && Arrays.equals(this.value, operationMergeFileData.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.outlineName, this.source, this.uri, Arrays.hashCode(this.value)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationMergeFileData {\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    outlineName: ").append(this.toIndentedString(this.outlineName)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        VALUE(String.valueOf("value")),
        URI(String.valueOf("uri"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FormatEnum {
        PDF(String.valueOf("pdf")),
        ZIP(String.valueOf("zip")),
        ID(String.valueOf("id"));

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

