/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationSignatureIdentifier;
import net.webpdf.wsclient.openapi.OperationSignatureImage;
import net.webpdf.wsclient.openapi.OperationSignaturePosition;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define the signature's visual appearance.")
@JsonPropertyOrder(value={"identifier", "identifierElements", "image", "name", "page", "position", "showCommonName"})
@JsonTypeName(value="Operation_AppearanceAdd")
public class OperationAppearanceAdd {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier = "";
    public static final String JSON_PROPERTY_IDENTIFIER_ELEMENTS = "identifierElements";
    private OperationSignatureIdentifier identifierElements;
    public static final String JSON_PROPERTY_IMAGE = "image";
    private OperationSignatureImage image;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationSignaturePosition position;
    public static final String JSON_PROPERTY_SHOW_COMMON_NAME = "showCommonName";
    private Boolean showCommonName = true;

    public OperationAppearanceAdd identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Schema(name="Text that should be displayed in the signature's right-hand side text field. If a value is not specified, the field will display the name of the signatory and the name parts of the certificate (please refer to `<identifierElements>` further below).")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public OperationAppearanceAdd identifierElements(OperationSignatureIdentifier identifierElements) {
        this.identifierElements = identifierElements;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="identifierElements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationSignatureIdentifier getIdentifierElements() {
        return this.identifierElements;
    }

    @JsonProperty(value="identifierElements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifierElements(OperationSignatureIdentifier identifierElements) {
        this.identifierElements = identifierElements;
    }

    public OperationAppearanceAdd image(OperationSignatureImage image) {
        this.image = image;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationSignatureImage getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImage(OperationSignatureImage image) {
        this.image = image;
    }

    public OperationAppearanceAdd name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Name that will be displayed in the signature's left-hand side area. If no value is specified, the name of the signer is displayed in this area (CN name part from the certificate) if `showCommonName` is enabled.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationAppearanceAdd page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Defines the page on which the signature is to be displayed.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationAppearanceAdd position(OperationSignaturePosition position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationSignaturePosition getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationSignaturePosition position) {
        this.position = position;
    }

    public OperationAppearanceAdd showCommonName(Boolean showCommonName) {
        this.showCommonName = showCommonName;
        return this;
    }

    @Schema(name="Displays or hides the certificate name (CN) of the certificate in the signature's left-hand side area. A set `name` always has priority over the setting of this option.")
    @JsonProperty(value="showCommonName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowCommonName() {
        return this.showCommonName;
    }

    @JsonProperty(value="showCommonName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowCommonName(Boolean showCommonName) {
        this.showCommonName = showCommonName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationAppearanceAdd operationAppearanceAdd = (OperationAppearanceAdd)o;
        return Objects.equals(this.identifier, operationAppearanceAdd.identifier) && Objects.equals(this.identifierElements, operationAppearanceAdd.identifierElements) && Objects.equals(this.image, operationAppearanceAdd.image) && Objects.equals(this.name, operationAppearanceAdd.name) && Objects.equals(this.page, operationAppearanceAdd.page) && Objects.equals(this.position, operationAppearanceAdd.position) && Objects.equals(this.showCommonName, operationAppearanceAdd.showCommonName);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.identifierElements, this.image, this.name, this.page, this.position, this.showCommonName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationAppearanceAdd {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    identifierElements: ").append(this.toIndentedString(this.identifierElements)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    showCommonName: ").append(this.toIndentedString(this.showCommonName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

