/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Lists a set of further settings and definitions, that a Reader may honor, when displaying the document.")
@JsonPropertyOrder(value={"centerWindow", "displayDocTitle", "duplex", "fitWindow", "hideMenuBar", "hideToolbar", "hideWindowUI", "nonFullScreenPageMode", "numCopies", "printArea", "printClip", "printPageRange", "printScaling", "printTraySelection", "textDirection", "viewArea", "viewClip"})
@JsonTypeName(value="Metadata_ViewerPreferences")
public class MetadataViewerPreferences {
    public static final String JSON_PROPERTY_CENTER_WINDOW = "centerWindow";
    private Boolean centerWindow = false;
    public static final String JSON_PROPERTY_DISPLAY_DOC_TITLE = "displayDocTitle";
    private Boolean displayDocTitle = false;
    public static final String JSON_PROPERTY_DUPLEX = "duplex";
    private DuplexEnum duplex = DuplexEnum.NONE;
    public static final String JSON_PROPERTY_FIT_WINDOW = "fitWindow";
    private Boolean fitWindow = false;
    public static final String JSON_PROPERTY_HIDE_MENU_BAR = "hideMenuBar";
    private Boolean hideMenuBar = false;
    public static final String JSON_PROPERTY_HIDE_TOOLBAR = "hideToolbar";
    private Boolean hideToolbar = false;
    public static final String JSON_PROPERTY_HIDE_WINDOW_U_I = "hideWindowUI";
    private Boolean hideWindowUI = false;
    public static final String JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE = "nonFullScreenPageMode";
    private NonFullScreenPageModeEnum nonFullScreenPageMode = NonFullScreenPageModeEnum.NONE;
    public static final String JSON_PROPERTY_NUM_COPIES = "numCopies";
    private Integer numCopies = 1;
    public static final String JSON_PROPERTY_PRINT_AREA = "printArea";
    private PrintAreaEnum printArea = PrintAreaEnum.CROP_BOX;
    public static final String JSON_PROPERTY_PRINT_CLIP = "printClip";
    private PrintClipEnum printClip = PrintClipEnum.CROP_BOX;
    public static final String JSON_PROPERTY_PRINT_PAGE_RANGE = "printPageRange";
    private String printPageRange = "";
    public static final String JSON_PROPERTY_PRINT_SCALING = "printScaling";
    private PrintScalingEnum printScaling = PrintScalingEnum.READER_DEFAULT;
    public static final String JSON_PROPERTY_PRINT_TRAY_SELECTION = "printTraySelection";
    private PrintTraySelectionEnum printTraySelection = PrintTraySelectionEnum.READER_DEFAULT;
    public static final String JSON_PROPERTY_TEXT_DIRECTION = "textDirection";
    private TextDirectionEnum textDirection = TextDirectionEnum.LEFT_TO_RIGHT;
    public static final String JSON_PROPERTY_VIEW_AREA = "viewArea";
    private ViewAreaEnum viewArea = ViewAreaEnum.CROP_BOX;
    public static final String JSON_PROPERTY_VIEW_CLIP = "viewClip";
    private ViewClipEnum viewClip = ViewClipEnum.CROP_BOX;

    public MetadataViewerPreferences centerWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
        return this;
    }

    @Schema(name="The Reader's window shall be positioned at the center of the screen, when opening the document.")
    @JsonProperty(value="centerWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCenterWindow() {
        return this.centerWindow;
    }

    @JsonProperty(value="centerWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCenterWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
    }

    public MetadataViewerPreferences displayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
        return this;
    }

    @Schema(name="Instead of the file name the reader shall display the title of the document in it's title bar.")
    @JsonProperty(value="displayDocTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDisplayDocTitle() {
        return this.displayDocTitle;
    }

    @JsonProperty(value="displayDocTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
    }

    public MetadataViewerPreferences duplex(DuplexEnum duplex) {
        this.duplex = duplex;
        return this;
    }

    @Schema(name="The duplex settings initially suggested when opening the Reader's print dialog.  *   none = The Reader shall use it's default suggestion. *   simplex = The Reader shall suggest simplex printing. *   duplexFlipShortEdge = The Reader shall suggest duplex printing, flipping pages over the shorter edge. *   duplexFlipLongEdge = The Reader shall suggest duplex printing, flipping pages over the longer edge.")
    @JsonProperty(value="duplex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DuplexEnum getDuplex() {
        return this.duplex;
    }

    @JsonProperty(value="duplex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDuplex(DuplexEnum duplex) {
        this.duplex = duplex;
    }

    public MetadataViewerPreferences fitWindow(Boolean fitWindow) {
        this.fitWindow = fitWindow;
        return this;
    }

    @Schema(name="The dimensions of the Reader's window shall adapt to the first displayed page of the document.")
    @JsonProperty(value="fitWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFitWindow() {
        return this.fitWindow;
    }

    @JsonProperty(value="fitWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFitWindow(Boolean fitWindow) {
        this.fitWindow = fitWindow;
    }

    public MetadataViewerPreferences hideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
        return this;
    }

    @Schema(name="The Reader's menu bar shall be hidden, when opening the document.")
    @JsonProperty(value="hideMenuBar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHideMenuBar() {
        return this.hideMenuBar;
    }

    @JsonProperty(value="hideMenuBar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
    }

    public MetadataViewerPreferences hideToolbar(Boolean hideToolbar) {
        this.hideToolbar = hideToolbar;
        return this;
    }

    @Schema(name="The Reader's toolbars shall be hidden, when opening the document.")
    @JsonProperty(value="hideToolbar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHideToolbar() {
        return this.hideToolbar;
    }

    @JsonProperty(value="hideToolbar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideToolbar(Boolean hideToolbar) {
        this.hideToolbar = hideToolbar;
    }

    public MetadataViewerPreferences hideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
        return this;
    }

    @Schema(name="The Reader's navigation controls (such as scrollbars) shall be hidden, when opening the document.")
    @JsonProperty(value="hideWindowUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHideWindowUI() {
        return this.hideWindowUI;
    }

    @JsonProperty(value="hideWindowUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
    }

    public MetadataViewerPreferences nonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
        return this;
    }

    @Schema(name="When displaying a document in windowed mode, the Reader shall show the selected panel.  *   none = No panel shall be opened. *   outlines = The document's outlines shall be displayed. *   thumbnails = The document's page thumbnails shall be shown. *   optionalContents = document's layers (OCGs - Optional Content Groups) shall be displayed.")
    @JsonProperty(value="nonFullScreenPageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public NonFullScreenPageModeEnum getNonFullScreenPageMode() {
        return this.nonFullScreenPageMode;
    }

    @JsonProperty(value="nonFullScreenPageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
    }

    public MetadataViewerPreferences numCopies(Integer numCopies) {
        this.numCopies = numCopies;
        return this;
    }

    @Schema(name="The number of copies initially suggested, when opening the Reader's print dialog.")
    @JsonProperty(value="numCopies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getNumCopies() {
        return this.numCopies;
    }

    @JsonProperty(value="numCopies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumCopies(Integer numCopies) {
        this.numCopies = numCopies;
    }

    public MetadataViewerPreferences printArea(PrintAreaEnum printArea) {
        this.printArea = printArea;
        return this;
    }

    @Schema(name="Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="printArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintAreaEnum getPrintArea() {
        return this.printArea;
    }

    @JsonProperty(value="printArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintArea(PrintAreaEnum printArea) {
        this.printArea = printArea;
    }

    public MetadataViewerPreferences printClip(PrintClipEnum printClip) {
        this.printClip = printClip;
        return this;
    }

    @Schema(name="Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="printClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintClipEnum getPrintClip() {
        return this.printClip;
    }

    @JsonProperty(value="printClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintClip(PrintClipEnum printClip) {
        this.printClip = printClip;
    }

    public MetadataViewerPreferences printPageRange(String printPageRange) {
        this.printPageRange = printPageRange;
        return this;
    }

    @Schema(name="Selects the page range, that shall initially be suggested for printing, when opening the Reader's print dialog. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
    @JsonProperty(value="printPageRange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPrintPageRange() {
        return this.printPageRange;
    }

    @JsonProperty(value="printPageRange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintPageRange(String printPageRange) {
        this.printPageRange = printPageRange;
    }

    public MetadataViewerPreferences printScaling(PrintScalingEnum printScaling) {
        this.printScaling = printScaling;
        return this;
    }

    @Schema(name="The print scaling initially suggested when opening the Reader's print dialog.  *   readerDefault = The Reader shall use it's default suggestion. *   byPDFSize = The Reader shall suggest to not scale the document during printing.")
    @JsonProperty(value="printScaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintScalingEnum getPrintScaling() {
        return this.printScaling;
    }

    @JsonProperty(value="printScaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintScaling(PrintScalingEnum printScaling) {
        this.printScaling = printScaling;
    }

    public MetadataViewerPreferences printTraySelection(PrintTraySelectionEnum printTraySelection) {
        this.printTraySelection = printTraySelection;
        return this;
    }

    @Schema(name="The print tray selection initially suggested when opening the Reader's print dialog.  *   readerDefault = The Reader shall use it's default suggestion. *   byPDFSize = The Reader shall select a print tray, that matches the PDF's page dimensions.")
    @JsonProperty(value="printTraySelection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintTraySelectionEnum getPrintTraySelection() {
        return this.printTraySelection;
    }

    @JsonProperty(value="printTraySelection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintTraySelection(PrintTraySelectionEnum printTraySelection) {
        this.printTraySelection = printTraySelection;
    }

    public MetadataViewerPreferences textDirection(TextDirectionEnum textDirection) {
        this.textDirection = textDirection;
        return this;
    }

    @Schema(name="Selects the predominant document's text writing/reading direction.  *   leftToRight or *   rightToLeft")
    @JsonProperty(value="textDirection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public TextDirectionEnum getTextDirection() {
        return this.textDirection;
    }

    @JsonProperty(value="textDirection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTextDirection(TextDirectionEnum textDirection) {
        this.textDirection = textDirection;
    }

    public MetadataViewerPreferences viewArea(ViewAreaEnum viewArea) {
        this.viewArea = viewArea;
        return this;
    }

    @Schema(name="Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="viewArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ViewAreaEnum getViewArea() {
        return this.viewArea;
    }

    @JsonProperty(value="viewArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewArea(ViewAreaEnum viewArea) {
        this.viewArea = viewArea;
    }

    public MetadataViewerPreferences viewClip(ViewClipEnum viewClip) {
        this.viewClip = viewClip;
        return this;
    }

    @Schema(name="Selects the visible box, when displaying the document.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="viewClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ViewClipEnum getViewClip() {
        return this.viewClip;
    }

    @JsonProperty(value="viewClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewClip(ViewClipEnum viewClip) {
        this.viewClip = viewClip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataViewerPreferences metadataViewerPreferences = (MetadataViewerPreferences)o;
        return Objects.equals(this.centerWindow, metadataViewerPreferences.centerWindow) && Objects.equals(this.displayDocTitle, metadataViewerPreferences.displayDocTitle) && Objects.equals((Object)this.duplex, (Object)metadataViewerPreferences.duplex) && Objects.equals(this.fitWindow, metadataViewerPreferences.fitWindow) && Objects.equals(this.hideMenuBar, metadataViewerPreferences.hideMenuBar) && Objects.equals(this.hideToolbar, metadataViewerPreferences.hideToolbar) && Objects.equals(this.hideWindowUI, metadataViewerPreferences.hideWindowUI) && Objects.equals((Object)this.nonFullScreenPageMode, (Object)metadataViewerPreferences.nonFullScreenPageMode) && Objects.equals(this.numCopies, metadataViewerPreferences.numCopies) && Objects.equals((Object)this.printArea, (Object)metadataViewerPreferences.printArea) && Objects.equals((Object)this.printClip, (Object)metadataViewerPreferences.printClip) && Objects.equals(this.printPageRange, metadataViewerPreferences.printPageRange) && Objects.equals((Object)this.printScaling, (Object)metadataViewerPreferences.printScaling) && Objects.equals((Object)this.printTraySelection, (Object)metadataViewerPreferences.printTraySelection) && Objects.equals((Object)this.textDirection, (Object)metadataViewerPreferences.textDirection) && Objects.equals((Object)this.viewArea, (Object)metadataViewerPreferences.viewArea) && Objects.equals((Object)this.viewClip, (Object)metadataViewerPreferences.viewClip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.centerWindow, this.displayDocTitle, this.duplex, this.fitWindow, this.hideMenuBar, this.hideToolbar, this.hideWindowUI, this.nonFullScreenPageMode, this.numCopies, this.printArea, this.printClip, this.printPageRange, this.printScaling, this.printTraySelection, this.textDirection, this.viewArea, this.viewClip});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataViewerPreferences {\n");
        sb.append("    centerWindow: ").append(this.toIndentedString(this.centerWindow)).append("\n");
        sb.append("    displayDocTitle: ").append(this.toIndentedString(this.displayDocTitle)).append("\n");
        sb.append("    duplex: ").append(this.toIndentedString((Object)this.duplex)).append("\n");
        sb.append("    fitWindow: ").append(this.toIndentedString(this.fitWindow)).append("\n");
        sb.append("    hideMenuBar: ").append(this.toIndentedString(this.hideMenuBar)).append("\n");
        sb.append("    hideToolbar: ").append(this.toIndentedString(this.hideToolbar)).append("\n");
        sb.append("    hideWindowUI: ").append(this.toIndentedString(this.hideWindowUI)).append("\n");
        sb.append("    nonFullScreenPageMode: ").append(this.toIndentedString((Object)this.nonFullScreenPageMode)).append("\n");
        sb.append("    numCopies: ").append(this.toIndentedString(this.numCopies)).append("\n");
        sb.append("    printArea: ").append(this.toIndentedString((Object)this.printArea)).append("\n");
        sb.append("    printClip: ").append(this.toIndentedString((Object)this.printClip)).append("\n");
        sb.append("    printPageRange: ").append(this.toIndentedString(this.printPageRange)).append("\n");
        sb.append("    printScaling: ").append(this.toIndentedString((Object)this.printScaling)).append("\n");
        sb.append("    printTraySelection: ").append(this.toIndentedString((Object)this.printTraySelection)).append("\n");
        sb.append("    textDirection: ").append(this.toIndentedString((Object)this.textDirection)).append("\n");
        sb.append("    viewArea: ").append(this.toIndentedString((Object)this.viewArea)).append("\n");
        sb.append("    viewClip: ").append(this.toIndentedString((Object)this.viewClip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ViewClipEnum {
        MEDIA_BOX(String.valueOf("mediaBox")),
        CROP_BOX(String.valueOf("cropBox")),
        BLEED_BOX(String.valueOf("bleedBox")),
        TRIM_BOX(String.valueOf("trimBox")),
        ART_BOX(String.valueOf("artBox"));

        private String value;

        private ViewClipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ViewClipEnum fromValue(String value) {
            for (ViewClipEnum b : ViewClipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ViewAreaEnum {
        MEDIA_BOX(String.valueOf("mediaBox")),
        CROP_BOX(String.valueOf("cropBox")),
        BLEED_BOX(String.valueOf("bleedBox")),
        TRIM_BOX(String.valueOf("trimBox")),
        ART_BOX(String.valueOf("artBox"));

        private String value;

        private ViewAreaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ViewAreaEnum fromValue(String value) {
            for (ViewAreaEnum b : ViewAreaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TextDirectionEnum {
        LEFT_TO_RIGHT(String.valueOf("leftToRight")),
        RIGHT_TO_LEFT(String.valueOf("rightToLeft"));

        private String value;

        private TextDirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TextDirectionEnum fromValue(String value) {
            for (TextDirectionEnum b : TextDirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintTraySelectionEnum {
        READER_DEFAULT(String.valueOf("readerDefault")),
        BY_PDF_SIZE(String.valueOf("byPDFSize"));

        private String value;

        private PrintTraySelectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintTraySelectionEnum fromValue(String value) {
            for (PrintTraySelectionEnum b : PrintTraySelectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintScalingEnum {
        READER_DEFAULT(String.valueOf("readerDefault")),
        NO_PRINT_SCALING(String.valueOf("noPrintScaling"));

        private String value;

        private PrintScalingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintScalingEnum fromValue(String value) {
            for (PrintScalingEnum b : PrintScalingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintClipEnum {
        MEDIA_BOX(String.valueOf("mediaBox")),
        CROP_BOX(String.valueOf("cropBox")),
        BLEED_BOX(String.valueOf("bleedBox")),
        TRIM_BOX(String.valueOf("trimBox")),
        ART_BOX(String.valueOf("artBox"));

        private String value;

        private PrintClipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintClipEnum fromValue(String value) {
            for (PrintClipEnum b : PrintClipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintAreaEnum {
        MEDIA_BOX(String.valueOf("mediaBox")),
        CROP_BOX(String.valueOf("cropBox")),
        BLEED_BOX(String.valueOf("bleedBox")),
        TRIM_BOX(String.valueOf("trimBox")),
        ART_BOX(String.valueOf("artBox"));

        private String value;

        private PrintAreaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintAreaEnum fromValue(String value) {
            for (PrintAreaEnum b : PrintAreaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum NonFullScreenPageModeEnum {
        NONE(String.valueOf("none")),
        OUTLINES(String.valueOf("outlines")),
        THUMBNAILS(String.valueOf("thumbnails")),
        OPTIONAL_CONTENTS(String.valueOf("optionalContents"));

        private String value;

        private NonFullScreenPageModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NonFullScreenPageModeEnum fromValue(String value) {
            for (NonFullScreenPageModeEnum b : NonFullScreenPageModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DuplexEnum {
        NONE(String.valueOf("none")),
        SIMPLEX(String.valueOf("simplex")),
        DUPLEX_FLIP_SHORT_EDGE(String.valueOf("duplexFlipShortEdge")),
        DUPLEX_FLIP_LONG_EDGE(String.valueOf("duplexFlipLongEdge"));

        private String value;

        private DuplexEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DuplexEnum fromValue(String value) {
            for (DuplexEnum b : DuplexEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

