/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentFileFilterType;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a single filter rule for a file filter.")
@JsonPropertyOrder(value={"rulePattern", "ruleType"})
@JsonTypeName(value="Document_FileFilterRule")
public class DocumentFileFilterRule {
    public static final String JSON_PROPERTY_RULE_PATTERN = "rulePattern";
    private String rulePattern = "";
    public static final String JSON_PROPERTY_RULE_TYPE = "ruleType";
    private DocumentFileFilterType ruleType = DocumentFileFilterType.SUFFIX;

    public DocumentFileFilterRule rulePattern(String rulePattern) {
        this.rulePattern = rulePattern;
        return this;
    }

    @Schema(name="Defines the pattern of this rule. The syntax depends on the selected `ruleType`.")
    @JsonProperty(value="rulePattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRulePattern() {
        return this.rulePattern;
    }

    @JsonProperty(value="rulePattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRulePattern(String rulePattern) {
        this.rulePattern = rulePattern;
    }

    public DocumentFileFilterRule ruleType(DocumentFileFilterType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="ruleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocumentFileFilterType getRuleType() {
        return this.ruleType;
    }

    @JsonProperty(value="ruleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRuleType(DocumentFileFilterType ruleType) {
        this.ruleType = ruleType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFileFilterRule documentFileFilterRule = (DocumentFileFilterRule)o;
        return Objects.equals(this.rulePattern, documentFileFilterRule.rulePattern) && Objects.equals((Object)this.ruleType, (Object)documentFileFilterRule.ruleType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rulePattern, this.ruleType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentFileFilterRule {\n");
        sb.append("    rulePattern: ").append(this.toIndentedString(this.rulePattern)).append("\n");
        sb.append("    ruleType: ").append(this.toIndentedString((Object)this.ruleType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

