/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a TSA (Time Stamp Authority which supports [RFC3161](https://www.ietf.org/rfc/rfc3161.txt)) that shall be used by the server.")
@JsonPropertyOrder(value={"hashAlgorithm", "password", "url", "user"})
@JsonTypeName(value="ApplicationConfig_Tsa")
public class ApplicationConfigTsa {
    public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
    private HashAlgorithmEnum hashAlgorithm = HashAlgorithmEnum.SHA_1;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";
    public static final String JSON_PROPERTY_URL = "url";
    private String url = "";
    public static final String JSON_PROPERTY_USER = "user";
    private String user = "";

    public ApplicationConfigTsa hashAlgorithm(HashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    @Schema(name="The hashing algorithm used to check the validity of the timestamp.")
    @JsonProperty(value="hashAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public HashAlgorithmEnum getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @JsonProperty(value="hashAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHashAlgorithm(HashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public ApplicationConfigTsa password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="The password required for authentication with the TSA.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public ApplicationConfigTsa url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="The URL where the TSA can be reached.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public ApplicationConfigTsa user(String user) {
        this.user = user;
        return this;
    }

    @Schema(name="The username required for authentication with the TSA.")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigTsa applicationConfigTsa = (ApplicationConfigTsa)o;
        return Objects.equals((Object)this.hashAlgorithm, (Object)applicationConfigTsa.hashAlgorithm) && Objects.equals(this.password, applicationConfigTsa.password) && Objects.equals(this.url, applicationConfigTsa.url) && Objects.equals(this.user, applicationConfigTsa.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hashAlgorithm, this.password, this.url, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigTsa {\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.hashAlgorithm)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HashAlgorithmEnum {
        MD5(String.valueOf("MD5")),
        SHA_1(String.valueOf("SHA-1")),
        SHA_224(String.valueOf("SHA-224")),
        SHA_256(String.valueOf("SHA-256")),
        SHA_384(String.valueOf("SHA-384")),
        SHA_512(String.valueOf("SHA-512"));

        private String value;

        private HashAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HashAlgorithmEnum fromValue(String value) {
            for (HashAlgorithmEnum b : HashAlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

