/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AdminJobServerState;
import net.webpdf.wsclient.openapi.AdminPoolServerState;
import org.jetbrains.annotations.Nullable;

@Schema(description="Stores statistic information about a server instance and the executed jobs")
@JsonPropertyOrder(value={"instances", "jobs", "lastUpdate"})
@JsonTypeName(value="Admin_ServerState")
public class AdminServerState {
    public static final String JSON_PROPERTY_INSTANCES = "instances";
    private AdminPoolServerState instances;
    public static final String JSON_PROPERTY_JOBS = "jobs";
    private AdminJobServerState jobs;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private Long lastUpdate = 0L;

    public AdminServerState() {
    }

    @JsonCreator
    public AdminServerState(@JsonProperty(value="lastUpdate") Long lastUpdate) {
        this();
        this.lastUpdate = lastUpdate;
    }

    public AdminServerState instances(AdminPoolServerState instances) {
        this.instances = instances;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminPoolServerState getInstances() {
        return this.instances;
    }

    @JsonProperty(value="instances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstances(AdminPoolServerState instances) {
        this.instances = instances;
    }

    public AdminServerState jobs(AdminJobServerState jobs) {
        this.jobs = jobs;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="jobs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminJobServerState getJobs() {
        return this.jobs;
    }

    @JsonProperty(value="jobs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobs(AdminJobServerState jobs) {
        this.jobs = jobs;
    }

    @Schema(name="UTC datetime of last update")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminServerState adminServerState = (AdminServerState)o;
        return Objects.equals(this.instances, adminServerState.instances) && Objects.equals(this.jobs, adminServerState.jobs) && Objects.equals(this.lastUpdate, adminServerState.lastUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.instances, this.jobs, this.lastUpdate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminServerState {\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("    jobs: ").append(this.toIndentedString(this.jobs)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

