/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.AdminOsStatusContainer;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides information about the operating system on which the server is running")
@JsonPropertyOrder(value={"container", "cpuLogicalProcessors", "memoryCommittedVirtualSize", "memoryFree", "memoryFreeSwapSize", "memoryTotal", "memoryTotalSwapSize", "osArchitecture", "osName", "osVersion", "processCpuLoad", "systemLoadAverage"})
@JsonTypeName(value="Admin_OsStatus")
public class AdminOsStatus {
    public static final String JSON_PROPERTY_CONTAINER = "container";
    private AdminOsStatusContainer container;
    public static final String JSON_PROPERTY_CPU_LOGICAL_PROCESSORS = "cpuLogicalProcessors";
    private Integer cpuLogicalProcessors = 0;
    public static final String JSON_PROPERTY_MEMORY_COMMITTED_VIRTUAL_SIZE = "memoryCommittedVirtualSize";
    private Long memoryCommittedVirtualSize = 0L;
    public static final String JSON_PROPERTY_MEMORY_FREE = "memoryFree";
    private Long memoryFree = 0L;
    public static final String JSON_PROPERTY_MEMORY_FREE_SWAP_SIZE = "memoryFreeSwapSize";
    private Long memoryFreeSwapSize = 0L;
    public static final String JSON_PROPERTY_MEMORY_TOTAL = "memoryTotal";
    private Long memoryTotal = 0L;
    public static final String JSON_PROPERTY_MEMORY_TOTAL_SWAP_SIZE = "memoryTotalSwapSize";
    private Long memoryTotalSwapSize = 0L;
    public static final String JSON_PROPERTY_OS_ARCHITECTURE = "osArchitecture";
    private String osArchitecture = "";
    public static final String JSON_PROPERTY_OS_NAME = "osName";
    private String osName = "";
    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private String osVersion = "";
    public static final String JSON_PROPERTY_PROCESS_CPU_LOAD = "processCpuLoad";
    private Double processCpuLoad = 0.0;
    public static final String JSON_PROPERTY_SYSTEM_LOAD_AVERAGE = "systemLoadAverage";
    private Double systemLoadAverage = 0.0;

    public AdminOsStatus container(AdminOsStatusContainer container) {
        this.container = container;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="container")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public AdminOsStatusContainer getContainer() {
        return this.container;
    }

    @JsonProperty(value="container")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContainer(AdminOsStatusContainer container) {
        this.container = container;
    }

    public AdminOsStatus cpuLogicalProcessors(Integer cpuLogicalProcessors) {
        this.cpuLogicalProcessors = cpuLogicalProcessors;
        return this;
    }

    @Schema(name="The number of logical processors available to the application")
    @JsonProperty(value="cpuLogicalProcessors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getCpuLogicalProcessors() {
        return this.cpuLogicalProcessors;
    }

    @JsonProperty(value="cpuLogicalProcessors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCpuLogicalProcessors(Integer cpuLogicalProcessors) {
        this.cpuLogicalProcessors = cpuLogicalProcessors;
    }

    public AdminOsStatus memoryCommittedVirtualSize(Long memoryCommittedVirtualSize) {
        this.memoryCommittedVirtualSize = memoryCommittedVirtualSize;
        return this;
    }

    @Schema(name="The amount of virtual memory that is guaranteed to be available to the application in bytes")
    @JsonProperty(value="memoryCommittedVirtualSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getMemoryCommittedVirtualSize() {
        return this.memoryCommittedVirtualSize;
    }

    @JsonProperty(value="memoryCommittedVirtualSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMemoryCommittedVirtualSize(Long memoryCommittedVirtualSize) {
        this.memoryCommittedVirtualSize = memoryCommittedVirtualSize;
    }

    public AdminOsStatus memoryFree(Long memoryFree) {
        this.memoryFree = memoryFree;
        return this;
    }

    @Schema(name="The amount of free memory in bytes")
    @JsonProperty(value="memoryFree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getMemoryFree() {
        return this.memoryFree;
    }

    @JsonProperty(value="memoryFree")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMemoryFree(Long memoryFree) {
        this.memoryFree = memoryFree;
    }

    public AdminOsStatus memoryFreeSwapSize(Long memoryFreeSwapSize) {
        this.memoryFreeSwapSize = memoryFreeSwapSize;
        return this;
    }

    @Schema(name="The amount of free swap space in bytes")
    @JsonProperty(value="memoryFreeSwapSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getMemoryFreeSwapSize() {
        return this.memoryFreeSwapSize;
    }

    @JsonProperty(value="memoryFreeSwapSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMemoryFreeSwapSize(Long memoryFreeSwapSize) {
        this.memoryFreeSwapSize = memoryFreeSwapSize;
    }

    public AdminOsStatus memoryTotal(Long memoryTotal) {
        this.memoryTotal = memoryTotal;
        return this;
    }

    @Schema(name="The total amount of memory in bytes")
    @JsonProperty(value="memoryTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getMemoryTotal() {
        return this.memoryTotal;
    }

    @JsonProperty(value="memoryTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMemoryTotal(Long memoryTotal) {
        this.memoryTotal = memoryTotal;
    }

    public AdminOsStatus memoryTotalSwapSize(Long memoryTotalSwapSize) {
        this.memoryTotalSwapSize = memoryTotalSwapSize;
        return this;
    }

    @Schema(name="The total amount of swap space in bytes")
    @JsonProperty(value="memoryTotalSwapSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getMemoryTotalSwapSize() {
        return this.memoryTotalSwapSize;
    }

    @JsonProperty(value="memoryTotalSwapSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMemoryTotalSwapSize(Long memoryTotalSwapSize) {
        this.memoryTotalSwapSize = memoryTotalSwapSize;
    }

    public AdminOsStatus osArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
        return this;
    }

    @Schema(name="The operating system\u00b4s architecture")
    @JsonProperty(value="osArchitecture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    @JsonProperty(value="osArchitecture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public AdminOsStatus osName(String osName) {
        this.osName = osName;
        return this;
    }

    @Schema(name="The name of the operating system, the server is running on")
    @JsonProperty(value="osName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOsName() {
        return this.osName;
    }

    @JsonProperty(value="osName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsName(String osName) {
        this.osName = osName;
    }

    public AdminOsStatus osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @Schema(name="The operating system\u00b4s version number")
    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOsVersion() {
        return this.osVersion;
    }

    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public AdminOsStatus processCpuLoad(Double processCpuLoad) {
        this.processCpuLoad = processCpuLoad;
        return this;
    }

    @Schema(name="The recent CPU usage of the JVM with a value between 0.0 and 1.0 (a value of 1.0 means that threads were actively executed on all CPUs)")
    @JsonProperty(value="processCpuLoad")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Double getProcessCpuLoad() {
        return this.processCpuLoad;
    }

    @JsonProperty(value="processCpuLoad")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessCpuLoad(Double processCpuLoad) {
        this.processCpuLoad = processCpuLoad;
    }

    public AdminOsStatus systemLoadAverage(Double systemLoadAverage) {
        this.systemLoadAverage = systemLoadAverage;
        return this;
    }

    @Schema(name="The system load average for the last minute (or a negative value if not available)")
    @JsonProperty(value="systemLoadAverage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    @JsonProperty(value="systemLoadAverage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSystemLoadAverage(Double systemLoadAverage) {
        this.systemLoadAverage = systemLoadAverage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminOsStatus adminOsStatus = (AdminOsStatus)o;
        return Objects.equals(this.container, adminOsStatus.container) && Objects.equals(this.cpuLogicalProcessors, adminOsStatus.cpuLogicalProcessors) && Objects.equals(this.memoryCommittedVirtualSize, adminOsStatus.memoryCommittedVirtualSize) && Objects.equals(this.memoryFree, adminOsStatus.memoryFree) && Objects.equals(this.memoryFreeSwapSize, adminOsStatus.memoryFreeSwapSize) && Objects.equals(this.memoryTotal, adminOsStatus.memoryTotal) && Objects.equals(this.memoryTotalSwapSize, adminOsStatus.memoryTotalSwapSize) && Objects.equals(this.osArchitecture, adminOsStatus.osArchitecture) && Objects.equals(this.osName, adminOsStatus.osName) && Objects.equals(this.osVersion, adminOsStatus.osVersion) && Objects.equals(this.processCpuLoad, adminOsStatus.processCpuLoad) && Objects.equals(this.systemLoadAverage, adminOsStatus.systemLoadAverage);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.cpuLogicalProcessors, this.memoryCommittedVirtualSize, this.memoryFree, this.memoryFreeSwapSize, this.memoryTotal, this.memoryTotalSwapSize, this.osArchitecture, this.osName, this.osVersion, this.processCpuLoad, this.systemLoadAverage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminOsStatus {\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    cpuLogicalProcessors: ").append(this.toIndentedString(this.cpuLogicalProcessors)).append("\n");
        sb.append("    memoryCommittedVirtualSize: ").append(this.toIndentedString(this.memoryCommittedVirtualSize)).append("\n");
        sb.append("    memoryFree: ").append(this.toIndentedString(this.memoryFree)).append("\n");
        sb.append("    memoryFreeSwapSize: ").append(this.toIndentedString(this.memoryFreeSwapSize)).append("\n");
        sb.append("    memoryTotal: ").append(this.toIndentedString(this.memoryTotal)).append("\n");
        sb.append("    memoryTotalSwapSize: ").append(this.toIndentedString(this.memoryTotalSwapSize)).append("\n");
        sb.append("    osArchitecture: ").append(this.toIndentedString(this.osArchitecture)).append("\n");
        sb.append("    osName: ").append(this.toIndentedString(this.osName)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    processCpuLoad: ").append(this.toIndentedString(this.processCpuLoad)).append("\n");
        sb.append("    systemLoadAverage: ").append(this.toIndentedString(this.systemLoadAverage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

