/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.exception;

import org.jetbrains.annotations.NotNull;

public enum Error {
    UNKNOWN_EXCEPTION(-1, "Unknown exception."),
    UNKNOWN_WEBSERVICE_PROTOCOL(-2, "The selected webservice protocol is unknown."),
    UNKNOWN_WEBSERVICE_TYPE(-3, "The selected webservice type is not available."),
    INVALID_WEBSERVICE_URL(-4, "Invalid URL for webservice."),
    INVALID_SOURCE_DOCUMENT(-5, "Invalid file source."),
    INVALID_HTTP_MESSAGE_CONTENT(-6, "Failed to deserialize XML/JSON HTTP message content."),
    INVALID_DOCUMENT(-7, "The found document is invalid."),
    NO_OPERATION_DATA(-8, "No operation data available."),
    NO_DOCUMENT(-9, "No document defined."),
    INVALID_HISTORY_DATA(-10, "Invalid history parameter."),
    INVALID_WEBSERVICE_SESSION(-11, "Creating a webservice instance failed for the selected session."),
    INVALID_RESULT_DOCUMENT(-12, "The resulting document is invalid"),
    FAILED_TO_CLOSE_DATA_SOURCE(-13, "The data handlers of a {@link SoapDocument} failed to close."),
    INVALID_URL(-30, "Invalid URL."),
    HTTP_IO_ERROR(-31, "HTTP/HTTPS IO error."),
    TLS_INITIALIZATION_FAILURE(-32, "TLS initialization failed."),
    HTTP_EMPTY_ENTITY(-33, "HTTP entity is empty"),
    HTTP_CUSTOM_ERROR(-34, "HTTP custom error"),
    UNKNOWN_HTTP_METHOD(-35, "Unknown HTTP method"),
    UNKNOWN_SESSION_TYPE(-36, "Unknown session type"),
    XML_OR_JSON_CONVERSION_FAILURE(-37, "Unable to convert to XML/JSON"),
    INVALID_AUTH_MATERIAL(-40, "Authentication/authorization material is invalid"),
    AUTHENTICATION_FAILURE(-41, "The session authentication failed"),
    SESSION_REFRESH_FAILURE(-42, "Refreshing the session token failed"),
    WSDL_INVALID_FILE(-50, "Unable to access WSDL file"),
    WSDL_INVALID_URL(-51, "Invalid WSDL URL"),
    SOAP_EXECUTION(-52, "SOAP web service execution error"),
    REST_EXECUTION(-53, "REST web service execution error"),
    AUTH_ERROR(-54, "Authentication/Authorization failure."),
    ADMIN_PERMISSION_ERROR(-55, "Admin permission required.");

    private final int code;
    @NotNull
    private final String message;

    private Error(int code, String message) {
        this.code = code;
        this.message = message;
    }

    @NotNull
    public static Error getName(int errorCode) {
        for (Error error : Error.values()) {
            if (error.getCode() != errorCode) continue;
            return error;
        }
        return UNKNOWN_EXCEPTION;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }
}

