
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import net.webpdf.wsclient.schema.FileDataType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p567934_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p643558_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;ZUGFeRD file (XML) in "Base64 encoded" format. The ZUGFeRD XSD schema will be used to validate the file before embedding. If it is not valid, the operation will be aborted.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for ZugferdFileDataType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ZugferdFileDataType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>base64Binary">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FileDataGroup"/>
 *       <attribute name="version" type="{http://schema.webpdf.de/1.0/operation}ZugferdVersionType" default="v10Comfort" />
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ZugferdFileDataType", propOrder = {
    "value"
})
public class ZugferdFileDataType
    implements FileDataType<byte[]>
{

    @XmlValue
    protected byte[] value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p567934_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p643558_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the version of the ZUGFeRD XML file that should be embedded with "xmlFile". Versions 1.0, 2.0 and 2.1.x are supported. Only the "Comfort" profile is available for version 1.0. Meanwhile, the "Minimum", "Basic WL", "Basic", "EN16931" (Comfort), and "Extended" profiles are supported for version 2.0. Version 2.1.x contains the same profiles as version 2.0 and additionally defines the profile "X-Rechnung".&#13;
     *                                 List of versions with the corresponding profiles:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;v10Comfort&lt;/li&gt;&lt;li&gt;v20Minimum&lt;/li&gt;&lt;li&gt;v20BasicWL&lt;/li&gt;&lt;li&gt;v20Basic&lt;/li&gt;&lt;li&gt;v20EN16931&lt;/li&gt;&lt;li&gt;v20Extended&lt;/li&gt;&lt;li&gt;v21Minimum&lt;/li&gt;&lt;li&gt;v21BasicWL&lt;/li&gt;&lt;li&gt;v21Basic&lt;/li&gt;&lt;li&gt;v21EN16931&lt;/li&gt;&lt;li&gt;v21Extended&lt;/li&gt;&lt;li&gt;v21XRechnung&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "version")
    protected ZugferdVersionType version;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "source")
    protected FileDataSourceType source;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p567934_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p643558_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the version of the ZUGFeRD XML file that should be embedded with "xmlFile". Versions 1.0, 2.0 and 2.1.x are supported. Only the "Comfort" profile is available for version 1.0. Meanwhile, the "Minimum", "Basic WL", "Basic", "EN16931" (Comfort), and "Extended" profiles are supported for version 2.0. Version 2.1.x contains the same profiles as version 2.0 and additionally defines the profile "X-Rechnung".&#13;
     *                                 List of versions with the corresponding profiles:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;v10Comfort&lt;/li&gt;&lt;li&gt;v20Minimum&lt;/li&gt;&lt;li&gt;v20BasicWL&lt;/li&gt;&lt;li&gt;v20Basic&lt;/li&gt;&lt;li&gt;v20EN16931&lt;/li&gt;&lt;li&gt;v20Extended&lt;/li&gt;&lt;li&gt;v21Minimum&lt;/li&gt;&lt;li&gt;v21BasicWL&lt;/li&gt;&lt;li&gt;v21Basic&lt;/li&gt;&lt;li&gt;v21EN16931&lt;/li&gt;&lt;li&gt;v21Extended&lt;/li&gt;&lt;li&gt;v21XRechnung&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link ZugferdVersionType }
     *     
     */
    public ZugferdVersionType getVersion() {
        if (version == null) {
            return ZugferdVersionType.V_10_COMFORT;
        } else {
            return version;
        }
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link ZugferdVersionType }
     *     
     * @see #getVersion()
     */
    public void setVersion(ZugferdVersionType value) {
        this.version = value;
    }

    public boolean isSetVersion() {
        return (this.version!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FileDataSourceType }
     *     
     */
    public FileDataSourceType getSource() {
        if (source == null) {
            return FileDataSourceType.VALUE;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataSourceType }
     *     
     * @see #getSource()
     */
    public void setSource(FileDataSourceType value) {
        this.source = value;
    }

    public boolean isSetSource() {
        return (this.source!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        if (uri == null) {
            return "";
        } else {
            return uri;
        }
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUri()
     */
    public void setUri(String value) {
        this.uri = value;
    }

    public boolean isSetUri() {
        return (this.uri!= null);
    }

}
