
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The type of the resource passed&#13;
 *                     &lt;ul&gt;&lt;li&gt;xlst = An XSLT stylesheet to be used for the transformation.&lt;/li&gt;&lt;li&gt;other = Any other resource that is needed for the transformation. For example, this can be a CSS stylesheet, which is used by an output file of a transformation if it results in HTML output.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
 *                     The order of the resources can be important if multiple transformations are to be performed, i.e. multiple resources of the format "xlst" are passed. The transformations are performed in the order in which they are passed, in which case each transformation uses the output of the previous transformation as the starting point for its own transformation.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for XslTransformationFileFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="XslTransformationFileFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="xslt"/>
 *     <enumeration value="other"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "XslTransformationFileFormatType")
@XmlEnum
public enum XslTransformationFileFormatType {

    @XmlEnumValue("xslt")
    XSLT("xslt"),
    @XmlEnumValue("other")
    OTHER("other");
    private final String value;

    XslTransformationFileFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static XslTransformationFileFormatType fromValue(String v) {
        for (XslTransformationFileFormatType c: XslTransformationFileFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
