
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p190342_="https://jakarta.ee/xml/ns/jaxb" xmlns:p534392_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The xmp operation element can be used to add XMP metadata to the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for XmpType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="XmpType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <all>
 *         <element name="namespace" type="{http://schema.webpdf.de/1.0/operation}XmpNamespaceType"/>
 *         <element name="data" type="{http://schema.webpdf.de/1.0/operation}XmpFileDataType"/>
 *       </all>
 *       <attribute name="dataFormat" default="json">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}XmpDataFormatType">
 *             <enumeration value="json"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "XmpType", propOrder = {
    "namespace",
    "data"
})
public class XmpType
    extends BaseToolboxType
{

    @XmlElement(required = true)
    protected XmpNamespaceType namespace;
    @XmlElement(required = true)
    protected XmpFileDataType data;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p190342_="https://jakarta.ee/xml/ns/jaxb" xmlns:p534392_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Format for the XMP metadata being added. As of this writing, only "json" is supported.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dataFormat")
    protected XmpDataFormatType dataFormat;

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link XmpNamespaceType }
     *     
     */
    public XmpNamespaceType getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link XmpNamespaceType }
     *     
     */
    public void setNamespace(XmpNamespaceType value) {
        this.namespace = value;
    }

    public boolean isSetNamespace() {
        return (this.namespace!= null);
    }

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link XmpFileDataType }
     *     
     */
    public XmpFileDataType getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link XmpFileDataType }
     *     
     */
    public void setData(XmpFileDataType value) {
        this.data = value;
    }

    public boolean isSetData() {
        return (this.data!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p190342_="https://jakarta.ee/xml/ns/jaxb" xmlns:p534392_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Format for the XMP metadata being added. As of this writing, only "json" is supported.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link XmpDataFormatType }
     *     
     */
    public XmpDataFormatType getDataFormat() {
        if (dataFormat == null) {
            return XmpDataFormatType.JSON;
        } else {
            return dataFormat;
        }
    }

    /**
     * Sets the value of the dataFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link XmpDataFormatType }
     *     
     * @see #getDataFormat()
     */
    public void setDataFormat(XmpDataFormatType value) {
        this.dataFormat = value;
    }

    public boolean isSetDataFormat() {
        return (this.dataFormat!= null);
    }

}
