
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p526781_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p950257_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Uses one of multiple preset positions in order to position the watermark on the page.&#13;
 *                     &lt;ul&gt;&lt;li&gt;custom = Disable the use of a preset position.&lt;/li&gt;&lt;li&gt;top_left = Positions the watermark in the upper left corner.&lt;/li&gt;&lt;li&gt;top_center = Positions the watermark in the centre at the top margin.&lt;/li&gt;&lt;li&gt;top_right = Positions the watermark in the top right corner.&lt;/li&gt;&lt;li&gt;center_left = Positions the watermark at the centre of the page, to the left.&lt;/li&gt;&lt;li&gt;center_center = Positions the watermark at the centre of the page.&lt;/li&gt;&lt;li&gt;center_right = Positions the watermark at the centre of the page, to the right.&lt;/li&gt;&lt;li&gt;bottom_left = Positions the watermark in the bottom left corner.&lt;/li&gt;&lt;li&gt;bottom_center = Positions the watermark in the centre at the bottom margin.&lt;/li&gt;&lt;li&gt;bottom_right = Positions the watermark in the bottom right corner.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for WatermarkPositionModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="WatermarkPositionModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="custom"/>
 *     <enumeration value="top_left"/>
 *     <enumeration value="top_center"/>
 *     <enumeration value="top_right"/>
 *     <enumeration value="center_left"/>
 *     <enumeration value="center_center"/>
 *     <enumeration value="center_right"/>
 *     <enumeration value="bottom_left"/>
 *     <enumeration value="bottom_center"/>
 *     <enumeration value="bottom_right"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "WatermarkPositionModeType")
@XmlEnum
public enum WatermarkPositionModeType {

    @XmlEnumValue("custom")
    CUSTOM("custom"),
    @XmlEnumValue("top_left")
    TOP_LEFT("top_left"),
    @XmlEnumValue("top_center")
    TOP_CENTER("top_center"),
    @XmlEnumValue("top_right")
    TOP_RIGHT("top_right"),
    @XmlEnumValue("center_left")
    CENTER_LEFT("center_left"),
    @XmlEnumValue("center_center")
    CENTER_CENTER("center_center"),
    @XmlEnumValue("center_right")
    CENTER_RIGHT("center_right"),
    @XmlEnumValue("bottom_left")
    BOTTOM_LEFT("bottom_left"),
    @XmlEnumValue("bottom_center")
    BOTTOM_CENTER("bottom_center"),
    @XmlEnumValue("bottom_right")
    BOTTOM_RIGHT("bottom_right");
    private final String value;

    WatermarkPositionModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static WatermarkPositionModeType fromValue(String v) {
        for (WatermarkPositionModeType c: WatermarkPositionModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
