
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to specify the compression method when exporting pages as "tif" images. The following values are available:&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = No compression&lt;/li&gt;&lt;li&gt;rle = TIFF CCITT Modified Huffman RLE compression&lt;/li&gt;&lt;li&gt;deflate = TIFF Deflate lossless compression (Zip-in-TIFF).&lt;/li&gt;&lt;li&gt;group3 = TIFF CCITT Group 3 fax encoding&lt;/li&gt;&lt;li&gt;group4 = TIFF CCITT Group 4 fax encoding&lt;/li&gt;&lt;li&gt;jpeg = TIFF JPEG-in-TIFF compression&lt;/li&gt;&lt;li&gt;lzw = TIFF LZW compression&lt;/li&gt;&lt;li&gt;packbits = TIFF Byte-oriented run-length encoding "PackBits" compression&lt;/li&gt;&lt;li&gt;zlib = TIFF ZLib compression&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TiffCompressionType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TiffCompressionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="rle"/>
 *     <enumeration value="deflate"/>
 *     <enumeration value="group3"/>
 *     <enumeration value="group4"/>
 *     <enumeration value="jpeg"/>
 *     <enumeration value="lzw"/>
 *     <enumeration value="packbits"/>
 *     <enumeration value="zlib"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TiffCompressionType")
@XmlEnum
public enum TiffCompressionType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("rle")
    RLE("rle"),
    @XmlEnumValue("deflate")
    DEFLATE("deflate"),
    @XmlEnumValue("group3")
    GROUP_3("group3"),
    @XmlEnumValue("group4")
    GROUP_4("group4"),
    @XmlEnumValue("jpeg")
    JPEG("jpeg"),
    @XmlEnumValue("lzw")
    LZW("lzw"),
    @XmlEnumValue("packbits")
    PACKBITS("packbits"),
    @XmlEnumValue("zlib")
    ZLIB("zlib");
    private final String value;

    TiffCompressionType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TiffCompressionType fromValue(String v) {
        for (TiffCompressionType c: TiffCompressionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
