
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p310440_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p351123_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to configure the word wrap behaviour during highlighting&#13;
 *                     Possible values:&#13;
 *                     &lt;ul&gt;&lt;li&gt;auto = Automatic word wrap if necessary.&lt;/li&gt;&lt;li&gt;none = Suppress the addition of extra line breaks.&lt;/li&gt;&lt;li&gt;word = Line breaks allowed only after words.&lt;/li&gt;&lt;li&gt;all = Line breaks allowed unconditionally.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TextWrapModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TextWrapModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="auto"/>
 *     <enumeration value="none"/>
 *     <enumeration value="word"/>
 *     <enumeration value="all"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TextWrapModeType")
@XmlEnum
public enum TextWrapModeType {

    @XmlEnumValue("auto")
    AUTO("auto"),
    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("word")
    WORD("word"),
    @XmlEnumValue("all")
    ALL("all");
    private final String value;

    TextWrapModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TextWrapModeType fromValue(String v) {
        for (TextWrapModeType c: TextWrapModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
