
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the icon that should be displayed for the note on the page. The following values are available:&#13;
 *                     &lt;ul&gt;&lt;li&gt;check = The text annotation approves the content.&lt;/li&gt;&lt;li&gt;checkmark = The text annotation adds a gray checkmark to the content.&lt;/li&gt;&lt;li&gt;circle = The text annotation is a comment on the circled content.&lt;/li&gt;&lt;li&gt;comment = The text annotation is a comment to the marked contents.&lt;/li&gt;&lt;li&gt;cross = The text annotation marks the content or crosses it out.&lt;/li&gt;&lt;li&gt;crossHair = The text annotation targets the content in the crosshair.&lt;/li&gt;&lt;li&gt;insert = The text annotation is suggesting inserting some content.&lt;/li&gt;&lt;li&gt;key = The text annotation marks or contains a key content/information.&lt;/li&gt;&lt;li&gt;note = The text annotation is a mere note concerning the marked content.&lt;/li&gt;&lt;li&gt;help = The text annotation provides helpful information concerning the marked content.&lt;/li&gt;&lt;li&gt;newParagraph = The text annotation suggests adding a new Paragraph at a specific point.&lt;/li&gt;&lt;li&gt;paragraph = The text annotation is concerning the whole paragraph.&lt;/li&gt;&lt;li&gt;rightArrow = The text annotation is concerning the content to the right.&lt;/li&gt;&lt;li&gt;rightPointer = The text annotation is concerning the content to the right.&lt;/li&gt;&lt;li&gt;star = The text annotation marks content as especially important.&lt;/li&gt;&lt;li&gt;upArrow = The text annotation is concerning the content at the top.&lt;/li&gt;&lt;li&gt;upLeftArrow = The text annotation is concerning the content at the top left.&lt;/li&gt;&lt;li&gt;unnamed = The text annotation shall not provide a predefined name.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for TextAnnotationIconsType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="TextAnnotationIconsType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="check"/>
 *     <enumeration value="checkmark"/>
 *     <enumeration value="circle"/>
 *     <enumeration value="comment"/>
 *     <enumeration value="cross"/>
 *     <enumeration value="crossHair"/>
 *     <enumeration value="insert"/>
 *     <enumeration value="key"/>
 *     <enumeration value="note"/>
 *     <enumeration value="help"/>
 *     <enumeration value="newParagraph"/>
 *     <enumeration value="paragraph"/>
 *     <enumeration value="rightArrow"/>
 *     <enumeration value="rightPointer"/>
 *     <enumeration value="star"/>
 *     <enumeration value="upArrow"/>
 *     <enumeration value="upLeftArrow"/>
 *     <enumeration value="unnamed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TextAnnotationIconsType")
@XmlEnum
public enum TextAnnotationIconsType {

    @XmlEnumValue("check")
    CHECK("check"),
    @XmlEnumValue("checkmark")
    CHECKMARK("checkmark"),
    @XmlEnumValue("circle")
    CIRCLE("circle"),
    @XmlEnumValue("comment")
    COMMENT("comment"),
    @XmlEnumValue("cross")
    CROSS("cross"),
    @XmlEnumValue("crossHair")
    CROSS_HAIR("crossHair"),
    @XmlEnumValue("insert")
    INSERT("insert"),
    @XmlEnumValue("key")
    KEY("key"),
    @XmlEnumValue("note")
    NOTE("note"),
    @XmlEnumValue("help")
    HELP("help"),
    @XmlEnumValue("newParagraph")
    NEW_PARAGRAPH("newParagraph"),
    @XmlEnumValue("paragraph")
    PARAGRAPH("paragraph"),
    @XmlEnumValue("rightArrow")
    RIGHT_ARROW("rightArrow"),
    @XmlEnumValue("rightPointer")
    RIGHT_POINTER("rightPointer"),
    @XmlEnumValue("star")
    STAR("star"),
    @XmlEnumValue("upArrow")
    UP_ARROW("upArrow"),
    @XmlEnumValue("upLeftArrow")
    UP_LEFT_ARROW("upLeftArrow"),
    @XmlEnumValue("unnamed")
    UNNAMED("unnamed");
    private final String value;

    TextAnnotationIconsType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static TextAnnotationIconsType fromValue(String v) {
        for (TextAnnotationIconsType c: TextAnnotationIconsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
