
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When activated, the submitForm action will send the names and values of all selected form fields to the specified URL (Uniform Resource Locator). You can use the "field" element as many times as necessary.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SubmitFormActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SubmitFormActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <choice maxOccurs="unbounded">
 *         <element name="field" type="{http://schema.webpdf.de/1.0/operation}FormFieldSelectionType"/>
 *       </choice>
 *       <attribute name="url" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="exclude" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="includeNoValueFields" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="exportFormat" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="getMethod" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="submitCoordinates" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="xfdf" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="includeAppendSaves" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="includeAnnotations" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="submitPDF" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="canonicalFormat" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="excludeNonUserAnnotations" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="excludeFDFSourceOrTargetFile" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="embedForm" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SubmitFormActionType", propOrder = {
    "field"
})
public class SubmitFormActionType
    extends ActionEventType
{

    protected List<FormFieldSelectionType> field;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The URL to which the data should be transmitted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "url")
    protected String url;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, then all form fields except the selected ones should be exported. If false, only the selected ones will be.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "exclude")
    protected Boolean exclude;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, form fields that have not yet been filled out / that do not contain a value will be exported as well.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "includeNoValueFields")
    protected Boolean includeNoValueFields;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "submitPDF" and "xfdf" are not set. If this value is set to true, the data will be exported as an HTML form; otherwise, it will be exported in fdf (Forms Data Format) format.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "exportFormat")
    protected Boolean exportFormat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "exportFormat" is set and used. In this case, this value determines whether the names and values will be transmitted with GET (true) or HTTP POST (false) requests.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "getMethod")
    protected Boolean getMethod;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "exportFormat" is set and used. In this case, this value determines whether the position of the mouse click that triggered the export should also be part of the export.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "submitCoordinates")
    protected Boolean submitCoordinates;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "submitPDF" is not set. In this case, this value determines whether the data should be transmitted in XFDF format.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "xfdf")
    protected Boolean xfdf;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the transmitted data will reproduce all incremental changes in the form data.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "includeAppendSaves")
    protected Boolean includeAppendSaves;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the set mark-up annotations should be included in the transmitted data.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "includeAnnotations")
    protected Boolean includeAnnotations;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the data will be transmitted as a PDF file.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "submitPDF")
    protected Boolean submitPDF;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, all dates and times will be transmitted in a canonical standard format whenever possible.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canonicalFormat")
    protected Boolean canonicalFormat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format and "includeAnnotations" is set. In this case, this value determines whether the transmitted data should exclusively contain the annotations set by the user filling out the information (true) or whether it should contain all annotations instead (false).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "excludeNonUserAnnotations")
    protected Boolean excludeNonUserAnnotations;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the URL to which the data is being transmitted should be included in the export.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "excludeFDFSourceOrTargetFile")
    protected Boolean excludeFDFSourceOrTargetFile;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the PDF file that contains the form should be integrated into the transmitted data.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "embedForm")
    protected Boolean embedForm;

    /**
     * Gets the value of the field property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the field property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getField().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FormFieldSelectionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the field property.
     */
    public List<FormFieldSelectionType> getField() {
        if (field == null) {
            field = new ArrayList<>();
        }
        return this.field;
    }

    public boolean isSetField() {
        return ((this.field!= null)&&(!this.field.isEmpty()));
    }

    public void unsetField() {
        this.field = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The URL to which the data should be transmitted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUrl() {
        if (url == null) {
            return "";
        } else {
            return url;
        }
    }

    /**
     * Sets the value of the url property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUrl()
     */
    public void setUrl(String value) {
        this.url = value;
    }

    public boolean isSetUrl() {
        return (this.url!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, then all form fields except the selected ones should be exported. If false, only the selected ones will be.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExclude() {
        if (exclude == null) {
            return false;
        } else {
            return exclude;
        }
    }

    /**
     * Sets the value of the exclude property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isExclude()
     */
    public void setExclude(boolean value) {
        this.exclude = value;
    }

    public boolean isSetExclude() {
        return (this.exclude!= null);
    }

    public void unsetExclude() {
        this.exclude = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, form fields that have not yet been filled out / that do not contain a value will be exported as well.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIncludeNoValueFields() {
        if (includeNoValueFields == null) {
            return false;
        } else {
            return includeNoValueFields;
        }
    }

    /**
     * Sets the value of the includeNoValueFields property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIncludeNoValueFields()
     */
    public void setIncludeNoValueFields(boolean value) {
        this.includeNoValueFields = value;
    }

    public boolean isSetIncludeNoValueFields() {
        return (this.includeNoValueFields!= null);
    }

    public void unsetIncludeNoValueFields() {
        this.includeNoValueFields = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "submitPDF" and "xfdf" are not set. If this value is set to true, the data will be exported as an HTML form; otherwise, it will be exported in fdf (Forms Data Format) format.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExportFormat() {
        if (exportFormat == null) {
            return false;
        } else {
            return exportFormat;
        }
    }

    /**
     * Sets the value of the exportFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isExportFormat()
     */
    public void setExportFormat(boolean value) {
        this.exportFormat = value;
    }

    public boolean isSetExportFormat() {
        return (this.exportFormat!= null);
    }

    public void unsetExportFormat() {
        this.exportFormat = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "exportFormat" is set and used. In this case, this value determines whether the names and values will be transmitted with GET (true) or HTTP POST (false) requests.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isGetMethod() {
        if (getMethod == null) {
            return false;
        } else {
            return getMethod;
        }
    }

    /**
     * Sets the value of the getMethod property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isGetMethod()
     */
    public void setGetMethod(boolean value) {
        this.getMethod = value;
    }

    public boolean isSetGetMethod() {
        return (this.getMethod!= null);
    }

    public void unsetGetMethod() {
        this.getMethod = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "exportFormat" is set and used. In this case, this value determines whether the position of the mouse click that triggered the export should also be part of the export.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSubmitCoordinates() {
        if (submitCoordinates == null) {
            return false;
        } else {
            return submitCoordinates;
        }
    }

    /**
     * Sets the value of the submitCoordinates property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSubmitCoordinates()
     */
    public void setSubmitCoordinates(boolean value) {
        this.submitCoordinates = value;
    }

    public boolean isSetSubmitCoordinates() {
        return (this.submitCoordinates!= null);
    }

    public void unsetSubmitCoordinates() {
        this.submitCoordinates = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if "submitPDF" is not set. In this case, this value determines whether the data should be transmitted in XFDF format.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isXfdf() {
        if (xfdf == null) {
            return false;
        } else {
            return xfdf;
        }
    }

    /**
     * Sets the value of the xfdf property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isXfdf()
     */
    public void setXfdf(boolean value) {
        this.xfdf = value;
    }

    public boolean isSetXfdf() {
        return (this.xfdf!= null);
    }

    public void unsetXfdf() {
        this.xfdf = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the transmitted data will reproduce all incremental changes in the form data.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIncludeAppendSaves() {
        if (includeAppendSaves == null) {
            return false;
        } else {
            return includeAppendSaves;
        }
    }

    /**
     * Sets the value of the includeAppendSaves property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIncludeAppendSaves()
     */
    public void setIncludeAppendSaves(boolean value) {
        this.includeAppendSaves = value;
    }

    public boolean isSetIncludeAppendSaves() {
        return (this.includeAppendSaves!= null);
    }

    public void unsetIncludeAppendSaves() {
        this.includeAppendSaves = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the set mark-up annotations should be included in the transmitted data.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isIncludeAnnotations() {
        if (includeAnnotations == null) {
            return false;
        } else {
            return includeAnnotations;
        }
    }

    /**
     * Sets the value of the includeAnnotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIncludeAnnotations()
     */
    public void setIncludeAnnotations(boolean value) {
        this.includeAnnotations = value;
    }

    public boolean isSetIncludeAnnotations() {
        return (this.includeAnnotations!= null);
    }

    public void unsetIncludeAnnotations() {
        this.includeAnnotations = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the data will be transmitted as a PDF file.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSubmitPDF() {
        if (submitPDF == null) {
            return false;
        } else {
            return submitPDF;
        }
    }

    /**
     * Sets the value of the submitPDF property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSubmitPDF()
     */
    public void setSubmitPDF(boolean value) {
        this.submitPDF = value;
    }

    public boolean isSetSubmitPDF() {
        return (this.submitPDF!= null);
    }

    public void unsetSubmitPDF() {
        this.submitPDF = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, all dates and times will be transmitted in a canonical standard format whenever possible.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanonicalFormat() {
        if (canonicalFormat == null) {
            return false;
        } else {
            return canonicalFormat;
        }
    }

    /**
     * Sets the value of the canonicalFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanonicalFormat()
     */
    public void setCanonicalFormat(boolean value) {
        this.canonicalFormat = value;
    }

    public boolean isSetCanonicalFormat() {
        return (this.canonicalFormat!= null);
    }

    public void unsetCanonicalFormat() {
        this.canonicalFormat = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format and "includeAnnotations" is set. In this case, this value determines whether the transmitted data should exclusively contain the annotations set by the user filling out the information (true) or whether it should contain all annotations instead (false).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExcludeNonUserAnnotations() {
        if (excludeNonUserAnnotations == null) {
            return false;
        } else {
            return excludeNonUserAnnotations;
        }
    }

    /**
     * Sets the value of the excludeNonUserAnnotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isExcludeNonUserAnnotations()
     */
    public void setExcludeNonUserAnnotations(boolean value) {
        this.excludeNonUserAnnotations = value;
    }

    public boolean isSetExcludeNonUserAnnotations() {
        return (this.excludeNonUserAnnotations!= null);
    }

    public void unsetExcludeNonUserAnnotations() {
        this.excludeNonUserAnnotations = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the URL to which the data is being transmitted should be included in the export.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExcludeFDFSourceOrTargetFile() {
        if (excludeFDFSourceOrTargetFile == null) {
            return false;
        } else {
            return excludeFDFSourceOrTargetFile;
        }
    }

    /**
     * Sets the value of the excludeFDFSourceOrTargetFile property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isExcludeFDFSourceOrTargetFile()
     */
    public void setExcludeFDFSourceOrTargetFile(boolean value) {
        this.excludeFDFSourceOrTargetFile = value;
    }

    public boolean isSetExcludeFDFSourceOrTargetFile() {
        return (this.excludeFDFSourceOrTargetFile!= null);
    }

    public void unsetExcludeFDFSourceOrTargetFile() {
        this.excludeFDFSourceOrTargetFile = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the PDF file that contains the form should be integrated into the transmitted data.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEmbedForm() {
        if (embedForm == null) {
            return false;
        } else {
            return embedForm;
        }
    }

    /**
     * Sets the value of the embedForm property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isEmbedForm()
     */
    public void setEmbedForm(boolean value) {
        this.embedForm = value;
    }

    public boolean isSetEmbedForm() {
        return (this.embedForm!= null);
    }

    public void unsetEmbedForm() {
        this.embedForm = null;
    }

}
