
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the mode used to split the PDF document.&#13;
 *                     &lt;ul&gt;&lt;li&gt;last = Last page - Uses "pages" to define the last page that will be contained in the new PDF document.&lt;/li&gt;&lt;li&gt;first = First page - Uses "pages" to define the first page that will be contained in the new PDF document.&lt;/li&gt;&lt;li&gt;list = List of pages - Uses "pages" to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list.&lt;/li&gt;&lt;li&gt;single = Selected pages - Uses the "pages" attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages.&lt;/li&gt;&lt;li&gt;each = Every nth page - Uses the "pages" attribute to define the interval at which pages should be extracted. The "startPage" attribute is used to define the page on which the process will start. The result will be a ZIP file.&lt;/li&gt;&lt;li&gt;group = Group pages - Multiple pages will be added to a single PDF document. The "pages" attribute can be used to define how many pages will be saved in a single PDF document. The "startPage" attribute is used to define the page on which the process will start. The result will be a ZIP file.&lt;/li&gt;&lt;li&gt;burst = Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SplitModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="SplitModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="last"/>
 *     <enumeration value="first"/>
 *     <enumeration value="list"/>
 *     <enumeration value="single"/>
 *     <enumeration value="each"/>
 *     <enumeration value="group"/>
 *     <enumeration value="burst"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SplitModeType")
@XmlEnum
public enum SplitModeType {

    @XmlEnumValue("last")
    LAST("last"),
    @XmlEnumValue("first")
    FIRST("first"),
    @XmlEnumValue("list")
    LIST("list"),
    @XmlEnumValue("single")
    SINGLE("single"),
    @XmlEnumValue("each")
    EACH("each"),
    @XmlEnumValue("group")
    GROUP("group"),
    @XmlEnumValue("burst")
    BURST("burst");
    private final String value;

    SplitModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static SplitModeType fromValue(String v) {
        for (SplitModeType c: SplitModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
