
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When activated, the playSound Element plays the specified audio data.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SoundActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SoundActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <all>
 *         <element name="sound" type="{http://www.w3.org/2001/XMLSchema}base64Binary"/>
 *       </all>
 *       <attribute name="volume" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="-100"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="synchronous" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="repeat" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="mix" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="samplingRate" default="8000">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="soundChannels" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="sampleSize" default="8">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="encoding" type="{http://schema.webpdf.de/1.0/operation}AudioEncodingType" default="Raw" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SoundActionType", propOrder = {
    "sound"
})
public class SoundActionType
    extends ActionEventType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The audio file that should be played. The file must be encoded as a BASE64 value. The passed file must be completely independent and contain all the information and data required to play it. The AIFF, AIFF-C, RIFF (*.wav), snd(*.au) audio formats are supported, for example.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlElement(required = true)
    protected byte[] sound;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A floating-point number between 100 and -100 that configures the volume for audio playback (as a percentage).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "volume")
    protected Integer volume;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the reader program must guarantee that the audio track will be plated in a completely synchronized manner without any interruptions and, accordingly, suppress any user interaction (except for cancelling the audio) while the audio is playing.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "synchronous")
    protected Boolean synchronous;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the audio track should be repeated endlessly.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "repeat")
    protected Boolean repeat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, it will be possible to play the audio track at the same time as other audio tracks. If it is set to false instead, any audio tracks that were already playing will be stopped previously.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "mix")
    protected Boolean mix;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Sample Rate in Samples per Second.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "samplingRate")
    protected Float samplingRate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of audio channels.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "soundChannels")
    protected Integer soundChannels;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of bits per sample per audio channel.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "sampleSize")
    protected Integer sampleSize;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The encoding of the audio file. Possible values are:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;Raw&lt;/li&gt;&lt;li&gt;Signed&lt;/li&gt;&lt;li&gt;muLaw&lt;/li&gt;&lt;li&gt;ALaw&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "encoding")
    protected AudioEncodingType encoding;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The audio file that should be played. The file must be encoded as a BASE64 value. The passed file must be completely independent and contain all the information and data required to play it. The AIFF, AIFF-C, RIFF (*.wav), snd(*.au) audio formats are supported, for example.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getSound() {
        return sound;
    }

    /**
     * Sets the value of the sound property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     * @see #getSound()
     */
    public void setSound(byte[] value) {
        this.sound = value;
    }

    public boolean isSetSound() {
        return (this.sound!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A floating-point number between 100 and -100 that configures the volume for audio playback (as a percentage).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getVolume() {
        if (volume == null) {
            return  100;
        } else {
            return volume;
        }
    }

    /**
     * Sets the value of the volume property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getVolume()
     */
    public void setVolume(int value) {
        this.volume = value;
    }

    public boolean isSetVolume() {
        return (this.volume!= null);
    }

    public void unsetVolume() {
        this.volume = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the reader program must guarantee that the audio track will be plated in a completely synchronized manner without any interruptions and, accordingly, suppress any user interaction (except for cancelling the audio) while the audio is playing.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSynchronous() {
        if (synchronous == null) {
            return false;
        } else {
            return synchronous;
        }
    }

    /**
     * Sets the value of the synchronous property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isSynchronous()
     */
    public void setSynchronous(boolean value) {
        this.synchronous = value;
    }

    public boolean isSetSynchronous() {
        return (this.synchronous!= null);
    }

    public void unsetSynchronous() {
        this.synchronous = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, the audio track should be repeated endlessly.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRepeat() {
        if (repeat == null) {
            return false;
        } else {
            return repeat;
        }
    }

    /**
     * Sets the value of the repeat property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isRepeat()
     */
    public void setRepeat(boolean value) {
        this.repeat = value;
    }

    public boolean isSetRepeat() {
        return (this.repeat!= null);
    }

    public void unsetRepeat() {
        this.repeat = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If this value is set to true, it will be possible to play the audio track at the same time as other audio tracks. If it is set to false instead, any audio tracks that were already playing will be stopped previously.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMix() {
        if (mix == null) {
            return false;
        } else {
            return mix;
        }
    }

    /**
     * Sets the value of the mix property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isMix()
     */
    public void setMix(boolean value) {
        this.mix = value;
    }

    public boolean isSetMix() {
        return (this.mix!= null);
    }

    public void unsetMix() {
        this.mix = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The Sample Rate in Samples per Second.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getSamplingRate() {
        if (samplingRate == null) {
            return  8000.0F;
        } else {
            return samplingRate;
        }
    }

    /**
     * Sets the value of the samplingRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getSamplingRate()
     */
    public void setSamplingRate(float value) {
        this.samplingRate = value;
    }

    public boolean isSetSamplingRate() {
        return (this.samplingRate!= null);
    }

    public void unsetSamplingRate() {
        this.samplingRate = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of audio channels.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSoundChannels() {
        if (soundChannels == null) {
            return  1;
        } else {
            return soundChannels;
        }
    }

    /**
     * Sets the value of the soundChannels property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSoundChannels()
     */
    public void setSoundChannels(int value) {
        this.soundChannels = value;
    }

    public boolean isSetSoundChannels() {
        return (this.soundChannels!= null);
    }

    public void unsetSoundChannels() {
        this.soundChannels = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The number of bits per sample per audio channel.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSampleSize() {
        if (sampleSize == null) {
            return  8;
        } else {
            return sampleSize;
        }
    }

    /**
     * Sets the value of the sampleSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSampleSize()
     */
    public void setSampleSize(int value) {
        this.sampleSize = value;
    }

    public boolean isSetSampleSize() {
        return (this.sampleSize!= null);
    }

    public void unsetSampleSize() {
        this.sampleSize = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The encoding of the audio file. Possible values are:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;Raw&lt;/li&gt;&lt;li&gt;Signed&lt;/li&gt;&lt;li&gt;muLaw&lt;/li&gt;&lt;li&gt;ALaw&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link AudioEncodingType }
     *     
     */
    public AudioEncodingType getEncoding() {
        if (encoding == null) {
            return AudioEncodingType.RAW;
        } else {
            return encoding;
        }
    }

    /**
     * Sets the value of the encoding property.
     * 
     * @param value
     *     allowed object is
     *     {@link AudioEncodingType }
     *     
     * @see #getEncoding()
     */
    public void setEncoding(AudioEncodingType value) {
        this.encoding = value;
    }

    public boolean isSetEncoding() {
        return (this.encoding!= null);
    }

}
