
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of signatures. A web service whose execution for a given signed document would violate the ruleset selected here should instead abort with an appropriate error code.&#13;
 *                     &lt;ul&gt;&lt;li&gt;adobeRestrictions = Only those changes are allowed that are enabled by the included signatures. This follows the specifications given by Adobe.&lt;/li&gt;&lt;li&gt;generalEditRestrictions = All changes to signed documents are prohibited, even those that might be allowed according to the included signatures.&lt;/li&gt;&lt;li&gt;noEditRestrictions = Editing of signed documents is not restricted and all changes are allowed (by doing this, you accept that all signatures could potentially be removed from the document when necessary).&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for SignatureEditProfileType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="SignatureEditProfileType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="adobeRestrictions"/>
 *     <enumeration value="generalEditRestrictions"/>
 *     <enumeration value="noEditRestrictions"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SignatureEditProfileType")
@XmlEnum
public enum SignatureEditProfileType {

    @XmlEnumValue("adobeRestrictions")
    ADOBE_RESTRICTIONS("adobeRestrictions"),
    @XmlEnumValue("generalEditRestrictions")
    GENERAL_EDIT_RESTRICTIONS("generalEditRestrictions"),
    @XmlEnumValue("noEditRestrictions")
    NO_EDIT_RESTRICTIONS("noEditRestrictions");
    private final String value;

    SignatureEditProfileType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static SignatureEditProfileType fromValue(String v) {
        for (SignatureEditProfileType c: SignatureEditProfileType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
