
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The known "named" icon types for rubberstamp annotations:&#13;
 *                     &lt;ul&gt;&lt;li&gt;approved = A stamp that marks the stamped context as approved.&lt;/li&gt;&lt;li&gt;experimental = A stamp that marks the stamped content to be an experimental state.&lt;/li&gt;&lt;li&gt;notApproved = A stamp that disapproves the stamped context.&lt;/li&gt;&lt;li&gt;asIs = A stamp that marks the content as is.&lt;/li&gt;&lt;li&gt;expired = A stamp that marks the contained information as no longer valid.&lt;/li&gt;&lt;li&gt;notForPublicRelease = A stamp that marks something as information for internal use only.&lt;/li&gt;&lt;li&gt;confidential = A stamp marking the page as confidential.&lt;/li&gt;&lt;li&gt;final = A stamp that indicates, that the current state of the document is final.&lt;/li&gt;&lt;li&gt;sold = A stamp that indicates the marked contents to be sold and no longer available.&lt;/li&gt;&lt;li&gt;departmental = A stamp that forbids information to be shared to recipient outside of a given department.&lt;/li&gt;&lt;li&gt;forComment = Marks the stamped context as a comment.&lt;/li&gt;&lt;li&gt;topSecret = Marks the stamped content not to be shared publicly.&lt;/li&gt;&lt;li&gt;draft = A stamp marking the content to be a draft and therefore a work in progress.&lt;/li&gt;&lt;li&gt;forPublicRelease = Marks the content for public sharing.&lt;/li&gt;&lt;li&gt;unnamed = The rubberstamp shall not provide a predefined name.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for RubberStampIconType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="RubberStampIconType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="approved"/>
 *     <enumeration value="experimental"/>
 *     <enumeration value="notApproved"/>
 *     <enumeration value="asIs"/>
 *     <enumeration value="expired"/>
 *     <enumeration value="notForPublicRelease"/>
 *     <enumeration value="confidential"/>
 *     <enumeration value="final"/>
 *     <enumeration value="sold"/>
 *     <enumeration value="departmental"/>
 *     <enumeration value="forComment"/>
 *     <enumeration value="topSecret"/>
 *     <enumeration value="draft"/>
 *     <enumeration value="forPublicRelease"/>
 *     <enumeration value="unnamed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "RubberStampIconType")
@XmlEnum
public enum RubberStampIconType {

    @XmlEnumValue("approved")
    APPROVED("approved"),
    @XmlEnumValue("experimental")
    EXPERIMENTAL("experimental"),
    @XmlEnumValue("notApproved")
    NOT_APPROVED("notApproved"),
    @XmlEnumValue("asIs")
    AS_IS("asIs"),
    @XmlEnumValue("expired")
    EXPIRED("expired"),
    @XmlEnumValue("notForPublicRelease")
    NOT_FOR_PUBLIC_RELEASE("notForPublicRelease"),
    @XmlEnumValue("confidential")
    CONFIDENTIAL("confidential"),
    @XmlEnumValue("final")
    FINAL("final"),
    @XmlEnumValue("sold")
    SOLD("sold"),
    @XmlEnumValue("departmental")
    DEPARTMENTAL("departmental"),
    @XmlEnumValue("forComment")
    FOR_COMMENT("forComment"),
    @XmlEnumValue("topSecret")
    TOP_SECRET("topSecret"),
    @XmlEnumValue("draft")
    DRAFT("draft"),
    @XmlEnumValue("forPublicRelease")
    FOR_PUBLIC_RELEASE("forPublicRelease"),
    @XmlEnumValue("unnamed")
    UNNAMED("unnamed");
    private final String value;

    RubberStampIconType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static RubberStampIconType fromValue(String v) {
        for (RubberStampIconType c: RubberStampIconType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
