
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The rotate operation element can be used to rotate pages in the document.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for RotateType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="RotateType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="1" />
 *       <attribute name="degrees" default="90">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="360"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pageOrientation" type="{http://schema.webpdf.de/1.0/operation}PageOrientationType" default="any" />
 *       <attribute name="pageGroup" type="{http://schema.webpdf.de/1.0/operation}PageGroupType" default="all" />
 *       <attribute name="orientationDetectMode" type="{http://schema.webpdf.de/1.0/operation}OrientationDetectionType" default="value" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RotateType")
public class RotateType
    extends BaseToolboxType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which page(s) should be rotated. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the clockwise rotation in degrees. The rotation is always in 90-degree increments (0, 90, 180, 270, 360). Deviating values will always be rounded down to the next lower increment (e.g.: 32 degrees will become 0 degrees and 101 degrees will become 90 degrees). Once the rotation is completed, the new value will be normalized to a range of 0 to 359 degrees. If the page being rotated has an impermissible value (e.g. 112 degrees), this value will be adjusted before the rotation operation as well (112 degrees will become 90 degrees).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "degrees")
    protected Integer degrees;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select pages based on their orientation within the specified page range:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;any = All pages&lt;/li&gt;&lt;li&gt;portrait = All pages in portrait format&lt;/li&gt;&lt;li&gt;landscape = All pages in landscape format&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pageOrientation")
    protected PageOrientationType pageOrientation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select pages based on their page number within the specified page range:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;all = All pages&lt;/li&gt;&lt;li&gt;even = All pages with an even page number&lt;/li&gt;&lt;li&gt;odd = All pages with an odd page number&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pageGroup")
    protected PageGroupType pageGroup;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also "pageOrientation"):&#13;
     *                                 &lt;ul&gt;&lt;li&gt;value = Based solely on the page rotation value entered in the PDF.&lt;/li&gt;&lt;li&gt;dimensions = Based on the ratio of the page dimensions to each other.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "orientationDetectMode")
    protected OrientationDetectionType orientationDetectMode;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which page(s) should be rotated. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9"). To specify "all pages," use an asterisk ("*").&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "1";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the clockwise rotation in degrees. The rotation is always in 90-degree increments (0, 90, 180, 270, 360). Deviating values will always be rounded down to the next lower increment (e.g.: 32 degrees will become 0 degrees and 101 degrees will become 90 degrees). Once the rotation is completed, the new value will be normalized to a range of 0 to 359 degrees. If the page being rotated has an impermissible value (e.g. 112 degrees), this value will be adjusted before the rotation operation as well (112 degrees will become 90 degrees).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDegrees() {
        if (degrees == null) {
            return  90;
        } else {
            return degrees;
        }
    }

    /**
     * Sets the value of the degrees property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDegrees()
     */
    public void setDegrees(int value) {
        this.degrees = value;
    }

    public boolean isSetDegrees() {
        return (this.degrees!= null);
    }

    public void unsetDegrees() {
        this.degrees = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select pages based on their orientation within the specified page range:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;any = All pages&lt;/li&gt;&lt;li&gt;portrait = All pages in portrait format&lt;/li&gt;&lt;li&gt;landscape = All pages in landscape format&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageOrientationType }
     *     
     */
    public PageOrientationType getPageOrientation() {
        if (pageOrientation == null) {
            return PageOrientationType.ANY;
        } else {
            return pageOrientation;
        }
    }

    /**
     * Sets the value of the pageOrientation property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageOrientationType }
     *     
     * @see #getPageOrientation()
     */
    public void setPageOrientation(PageOrientationType value) {
        this.pageOrientation = value;
    }

    public boolean isSetPageOrientation() {
        return (this.pageOrientation!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select pages based on their page number within the specified page range:&#13;
     *                                 &lt;ul&gt;&lt;li&gt;all = All pages&lt;/li&gt;&lt;li&gt;even = All pages with an even page number&lt;/li&gt;&lt;li&gt;odd = All pages with an odd page number&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageGroupType }
     *     
     */
    public PageGroupType getPageGroup() {
        if (pageGroup == null) {
            return PageGroupType.ALL;
        } else {
            return pageGroup;
        }
    }

    /**
     * Sets the value of the pageGroup property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageGroupType }
     *     
     * @see #getPageGroup()
     */
    public void setPageGroup(PageGroupType value) {
        this.pageGroup = value;
    }

    public boolean isSetPageGroup() {
        return (this.pageGroup!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects which criteria to use to determine the orientation (portrait/landscape) of pages (see also "pageOrientation"):&#13;
     *                                 &lt;ul&gt;&lt;li&gt;value = Based solely on the page rotation value entered in the PDF.&lt;/li&gt;&lt;li&gt;dimensions = Based on the ratio of the page dimensions to each other.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OrientationDetectionType }
     *     
     */
    public OrientationDetectionType getOrientationDetectMode() {
        if (orientationDetectMode == null) {
            return OrientationDetectionType.VALUE;
        } else {
            return orientationDetectMode;
        }
    }

    /**
     * Sets the value of the orientationDetectMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrientationDetectionType }
     *     
     * @see #getOrientationDetectMode()
     */
    public void setOrientationDetectMode(OrientationDetectionType value) {
        this.orientationDetectMode = value;
    }

    public boolean isSetOrientationDetectMode() {
        return (this.orientationDetectMode!= null);
    }

}
