
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A view of the 3D annotation that has been defined relative to the currently visualized view. This value is an alternative to "name" and "index" and does not have to be set if either one of these values are specified.&#13;
 *                     &lt;ul&gt;&lt;li&gt;First = The first view of the 3D annotation.&lt;/li&gt;&lt;li&gt;Last = The last view of the 3D annotation.&lt;/li&gt;&lt;li&gt;Next = The next view of the 3D annotation.&lt;/li&gt;&lt;li&gt;Previous = The previous view of the 3D annotation.&lt;/li&gt;&lt;li&gt;Default = The default view of the 3D annotation.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for RelativeThreeDViewOperationType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="RelativeThreeDViewOperationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="First"/>
 *     <enumeration value="Last"/>
 *     <enumeration value="Next"/>
 *     <enumeration value="Previous"/>
 *     <enumeration value="Default"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "RelativeThreeDViewOperationType")
@XmlEnum
public enum RelativeThreeDViewOperationType {

    @XmlEnumValue("First")
    FIRST("First"),
    @XmlEnumValue("Last")
    LAST("Last"),
    @XmlEnumValue("Next")
    NEXT("Next"),
    @XmlEnumValue("Previous")
    PREVIOUS("Previous"),
    @XmlEnumValue("Default")
    DEFAULT("Default");
    private final String value;

    RelativeThreeDViewOperationType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static RelativeThreeDViewOperationType fromValue(String v) {
        for (RelativeThreeDViewOperationType c: RelativeThreeDViewOperationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
