
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An annotation that marks page content for redaction.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for RedactAnnotationType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="RedactAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded" minOccurs="0">
 *                   <element name="pathElement" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *                   <element name="quadrilateral" type="{http://schema.webpdf.de/1.0/operation}QuadrilateralType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attribute name="interiorColor" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#000000" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RedactAnnotationType", propOrder = {
    "position"
})
public class RedactAnnotationType
    extends BaseAnnotationType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the pathelements in which the annotation shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     */
    protected RedactAnnotationType.Position position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation color will change the interior color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "interiorColor")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String interiorColor;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define the pathelements in which the annotation shall be positioned.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RedactAnnotationType.Position }
     *     
     */
    public RedactAnnotationType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RedactAnnotationType.Position }
     *     
     * @see #getPosition()
     */
    public void setPosition(RedactAnnotationType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p120009_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p426570_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p903434_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The annotation color will change the interior color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInteriorColor() {
        if (interiorColor == null) {
            return "#000000";
        } else {
            return interiorColor;
        }
    }

    /**
     * Sets the value of the interiorColor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getInteriorColor()
     */
    public void setInteriorColor(String value) {
        this.interiorColor = value;
    }

    public boolean isSetInteriorColor() {
        return (this.interiorColor!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="pathElement" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
     *         <element name="quadrilateral" type="{http://schema.webpdf.de/1.0/operation}QuadrilateralType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "pathElement",
        "quadrilateral"
    })
    public static class Position {

        protected List<RectangleType> pathElement;
        protected List<QuadrilateralType> quadrilateral;

        /**
         * Gets the value of the pathElement property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the pathElement property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getPathElement().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link RectangleType }
         * </p>
         * 
         * 
         * @return
         *     The value of the pathElement property.
         */
        public List<RectangleType> getPathElement() {
            if (pathElement == null) {
                pathElement = new ArrayList<>();
            }
            return this.pathElement;
        }

        public boolean isSetPathElement() {
            return ((this.pathElement!= null)&&(!this.pathElement.isEmpty()));
        }

        public void unsetPathElement() {
            this.pathElement = null;
        }

        /**
         * Gets the value of the quadrilateral property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the quadrilateral property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getQuadrilateral().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link QuadrilateralType }
         * </p>
         * 
         * 
         * @return
         *     The value of the quadrilateral property.
         */
        public List<QuadrilateralType> getQuadrilateral() {
            if (quadrilateral == null) {
                quadrilateral = new ArrayList<>();
            }
            return this.quadrilateral;
        }

        public boolean isSetQuadrilateral() {
            return ((this.quadrilateral!= null)&&(!this.quadrilateral.isEmpty()));
        }

        public void unsetQuadrilateral() {
            this.quadrilateral = null;
        }

    }

}
