
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.AccessPermissionType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines a rights recipient (Recipient) for the document to be encrypted. Recipients are defined on the basis of their rights and a certificate and are identified and distinguished on the basis of the certificate. Only with the associated "PrivateKey" and a certificate listed here can a user subsequently decrypt and open the document again.&#13;
 *                     Exactly one certificate is expected for encryption for each rights recipient. However, it is possible to define multiple rights recipients&#13;
 *                     &lt;ul&gt;&lt;li&gt;each with their own certificate.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for RecipientType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="RecipientType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="certificate" type="{http://schema.webpdf.de/1.0/operation}CertificateFileDataType"/>
 *       </all>
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}securityFlags"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RecipientType", propOrder = {

})
public class RecipientType
    implements AccessPermissionType
{

    @XmlElement(required = true)
    protected CertificateFileDataType certificate;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canAssemble")
    protected Boolean canAssemble;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) from the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canExtractContent")
    protected Boolean canExtractContent;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) for accessibility purposes.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canExtractForAccessibility")
    protected Boolean canExtractForAccessibility;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," form fields can be filled out and the document can be signed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canFillInForm")
    protected Boolean canFillInForm;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," changes to the document are permitted.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canModify")
    protected Boolean canModify;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," comments can be added to the document and deleted from the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canModifyAnnotations")
    protected Boolean canModifyAnnotations;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canPrint")
    protected Boolean canPrint;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed at high resolution levels.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "canPrintHighRes")
    protected Boolean canPrintHighRes;

    /**
     * Gets the value of the certificate property.
     * 
     * @return
     *     possible object is
     *     {@link CertificateFileDataType }
     *     
     */
    public CertificateFileDataType getCertificate() {
        return certificate;
    }

    /**
     * Sets the value of the certificate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertificateFileDataType }
     *     
     */
    public void setCertificate(CertificateFileDataType value) {
        this.certificate = value;
    }

    public boolean isSetCertificate() {
        return (this.certificate!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanAssemble() {
        if (canAssemble == null) {
            return false;
        } else {
            return canAssemble;
        }
    }

    /**
     * Sets the value of the canAssemble property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanAssemble()
     */
    public void setCanAssemble(boolean value) {
        this.canAssemble = value;
    }

    public boolean isSetCanAssemble() {
        return (this.canAssemble!= null);
    }

    public void unsetCanAssemble() {
        this.canAssemble = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) from the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanExtractContent() {
        if (canExtractContent == null) {
            return false;
        } else {
            return canExtractContent;
        }
    }

    /**
     * Sets the value of the canExtractContent property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanExtractContent()
     */
    public void setCanExtractContent(boolean value) {
        this.canExtractContent = value;
    }

    public boolean isSetCanExtractContent() {
        return (this.canExtractContent!= null);
    }

    public void unsetCanExtractContent() {
        this.canExtractContent = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," content can be extracted (copied) for accessibility purposes.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanExtractForAccessibility() {
        if (canExtractForAccessibility == null) {
            return false;
        } else {
            return canExtractForAccessibility;
        }
    }

    /**
     * Sets the value of the canExtractForAccessibility property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanExtractForAccessibility()
     */
    public void setCanExtractForAccessibility(boolean value) {
        this.canExtractForAccessibility = value;
    }

    public boolean isSetCanExtractForAccessibility() {
        return (this.canExtractForAccessibility!= null);
    }

    public void unsetCanExtractForAccessibility() {
        this.canExtractForAccessibility = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," form fields can be filled out and the document can be signed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanFillInForm() {
        if (canFillInForm == null) {
            return false;
        } else {
            return canFillInForm;
        }
    }

    /**
     * Sets the value of the canFillInForm property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanFillInForm()
     */
    public void setCanFillInForm(boolean value) {
        this.canFillInForm = value;
    }

    public boolean isSetCanFillInForm() {
        return (this.canFillInForm!= null);
    }

    public void unsetCanFillInForm() {
        this.canFillInForm = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," changes to the document are permitted.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanModify() {
        if (canModify == null) {
            return false;
        } else {
            return canModify;
        }
    }

    /**
     * Sets the value of the canModify property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanModify()
     */
    public void setCanModify(boolean value) {
        this.canModify = value;
    }

    public boolean isSetCanModify() {
        return (this.canModify!= null);
    }

    public void unsetCanModify() {
        this.canModify = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," comments can be added to the document and deleted from the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanModifyAnnotations() {
        if (canModifyAnnotations == null) {
            return false;
        } else {
            return canModifyAnnotations;
        }
    }

    /**
     * Sets the value of the canModifyAnnotations property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanModifyAnnotations()
     */
    public void setCanModifyAnnotations(boolean value) {
        this.canModifyAnnotations = value;
    }

    public boolean isSetCanModifyAnnotations() {
        return (this.canModifyAnnotations!= null);
    }

    public void unsetCanModifyAnnotations() {
        this.canModifyAnnotations = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanPrint() {
        if (canPrint == null) {
            return false;
        } else {
            return canPrint;
        }
    }

    /**
     * Sets the value of the canPrint property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanPrint()
     */
    public void setCanPrint(boolean value) {
        this.canPrint = value;
    }

    public boolean isSetCanPrint() {
        return (this.canPrint!= null);
    }

    public void unsetCanPrint() {
        this.canPrint = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p54688_="https://jakarta.ee/xml/ns/jaxb" xmlns:p573971_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," the document can be printed at high resolution levels.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCanPrintHighRes() {
        if (canPrintHighRes == null) {
            return false;
        } else {
            return canPrintHighRes;
        }
    }

    /**
     * Sets the value of the canPrintHighRes property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCanPrintHighRes()
     */
    public void setCanPrintHighRes(boolean value) {
        this.canPrintHighRes = value;
    }

    public boolean isSetCanPrintHighRes() {
        return (this.canPrintHighRes!= null);
    }

    public void unsetCanPrintHighRes() {
        this.canPrintHighRes = null;
    }

}
