
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the parts, that shall be included in the barcode.&#13;
 *                     &lt;ul&gt;&lt;li&gt;codeOnly = Only the barcode itself shall be shown.&lt;/li&gt;&lt;li&gt;billOnly = The barcode and the payment summary shall be shown.&lt;/li&gt;&lt;li&gt;billPortraitSheet = The dimensions of the barcode and the payment summary shall be optimized for placement in the lower left corner of a page in DIN-A4 format.&lt;/li&gt;&lt;li&gt;billExtraSpace = The same as "billPortraitSheet", but with extra spacings.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrSwissPaymentFormatType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="QrSwissPaymentFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="codeOnly"/>
 *     <enumeration value="billOnly"/>
 *     <enumeration value="billPortraitSheet"/>
 *     <enumeration value="billExtraSpace"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrSwissPaymentFormatType")
@XmlEnum
public enum QrSwissPaymentFormatType {

    @XmlEnumValue("codeOnly")
    CODE_ONLY("codeOnly"),
    @XmlEnumValue("billOnly")
    BILL_ONLY("billOnly"),
    @XmlEnumValue("billPortraitSheet")
    BILL_PORTRAIT_SHEET("billPortraitSheet"),
    @XmlEnumValue("billExtraSpace")
    BILL_EXTRA_SPACE("billExtraSpace");
    private final String value;

    QrSwissPaymentFormatType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static QrSwissPaymentFormatType fromValue(String v) {
        for (QrSwissPaymentFormatType c: QrSwissPaymentFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
