
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A swiss QR payment barcode.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for QrSwissPaymentBarcodeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="QrSwissPaymentBarcodeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="content" type="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentContentType"/>
 *         <element name="pdf" type="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentPdfType" minOccurs="0"/>
 *         <element name="position" type="{http://schema.webpdf.de/1.0/operation}RectangleType" minOccurs="0"/>
 *       </all>
 *       <attribute name="format" default="codeOnly">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentFormatType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="language" default="de">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentLanguageType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="dpi" type="{http://www.w3.org/2001/XMLSchema}int" default="200" />
 *       <attribute name="separator" type="{http://schema.webpdf.de/1.0/operation}QrSwissPaymentSeparatorType" default="dashedLineWithScissors" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "QrSwissPaymentBarcodeType", propOrder = {

})
public class QrSwissPaymentBarcodeType {

    @XmlElement(required = true)
    protected QrSwissPaymentContentType content;
    protected QrSwissPaymentPdfType pdf;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the position, the barcode shall be placed at.&lt;/p&gt;
     * </pre>
     * 
     */
    protected RectangleType position;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the parts, that shall be included in the barcode.&#13;
     *                         &lt;ul&gt;&lt;li&gt;codeOnly = Only the barcode itself shall be shown.&lt;/li&gt;&lt;li&gt;billOnly = The barcode and the payment summary shall be shown.&lt;/li&gt;&lt;li&gt;billPortraitSheet = The dimensions of the barcode and the payment summary shall be optimized for placement in the lower left corner of a page in DIN-A4 format.&lt;/li&gt;&lt;li&gt;billExtraSpace = The same as "billPortraitSheet", but with extra spacings.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "format")
    protected QrSwissPaymentFormatType format;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the language of the barcode's payment summary.&#13;
     *                         &lt;ul&gt;&lt;li&gt;de = german&lt;/li&gt;&lt;li&gt;fr = french&lt;/li&gt;&lt;li&gt;it = italian&lt;/li&gt;&lt;li&gt;en = english&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "language")
    protected QrSwissPaymentLanguageType language;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the resolution of the barcode.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "dpi")
    protected Integer dpi;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border style for separators in between the different parts of the barcode.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = No separator shall be used.&lt;/li&gt;&lt;li&gt;solidLine = A solid separator line.&lt;/li&gt;&lt;li&gt;solidLineWithScissors = A solid separator line with a scissor icon.&lt;/li&gt;&lt;li&gt;dashedLine = A dashed separator line.&lt;/li&gt;&lt;li&gt;dashedLineWithScissors = A dashed separator line with a scissor icon.&lt;/li&gt;&lt;li&gt;dottedLine = A dotted separator line.&lt;/li&gt;&lt;li&gt;dottedLineWithScissors = A dotted separator line with a scissor icon.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "separator")
    protected QrSwissPaymentSeparatorType separator;

    /**
     * Gets the value of the content property.
     * 
     * @return
     *     possible object is
     *     {@link QrSwissPaymentContentType }
     *     
     */
    public QrSwissPaymentContentType getContent() {
        return content;
    }

    /**
     * Sets the value of the content property.
     * 
     * @param value
     *     allowed object is
     *     {@link QrSwissPaymentContentType }
     *     
     */
    public void setContent(QrSwissPaymentContentType value) {
        this.content = value;
    }

    public boolean isSetContent() {
        return (this.content!= null);
    }

    /**
     * Gets the value of the pdf property.
     * 
     * @return
     *     possible object is
     *     {@link QrSwissPaymentPdfType }
     *     
     */
    public QrSwissPaymentPdfType getPdf() {
        return pdf;
    }

    /**
     * Sets the value of the pdf property.
     * 
     * @param value
     *     allowed object is
     *     {@link QrSwissPaymentPdfType }
     *     
     */
    public void setPdf(QrSwissPaymentPdfType value) {
        this.pdf = value;
    }

    public boolean isSetPdf() {
        return (this.pdf!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the position, the barcode shall be placed at.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link RectangleType }
     *     
     */
    public RectangleType getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RectangleType }
     *     
     * @see #getPosition()
     */
    public void setPosition(RectangleType value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the parts, that shall be included in the barcode.&#13;
     *                         &lt;ul&gt;&lt;li&gt;codeOnly = Only the barcode itself shall be shown.&lt;/li&gt;&lt;li&gt;billOnly = The barcode and the payment summary shall be shown.&lt;/li&gt;&lt;li&gt;billPortraitSheet = The dimensions of the barcode and the payment summary shall be optimized for placement in the lower left corner of a page in DIN-A4 format.&lt;/li&gt;&lt;li&gt;billExtraSpace = The same as "billPortraitSheet", but with extra spacings.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link QrSwissPaymentFormatType }
     *     
     */
    public QrSwissPaymentFormatType getFormat() {
        if (format == null) {
            return QrSwissPaymentFormatType.CODE_ONLY;
        } else {
            return format;
        }
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link QrSwissPaymentFormatType }
     *     
     * @see #getFormat()
     */
    public void setFormat(QrSwissPaymentFormatType value) {
        this.format = value;
    }

    public boolean isSetFormat() {
        return (this.format!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the language of the barcode's payment summary.&#13;
     *                         &lt;ul&gt;&lt;li&gt;de = german&lt;/li&gt;&lt;li&gt;fr = french&lt;/li&gt;&lt;li&gt;it = italian&lt;/li&gt;&lt;li&gt;en = english&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link QrSwissPaymentLanguageType }
     *     
     */
    public QrSwissPaymentLanguageType getLanguage() {
        if (language == null) {
            return QrSwissPaymentLanguageType.DE;
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link QrSwissPaymentLanguageType }
     *     
     * @see #getLanguage()
     */
    public void setLanguage(QrSwissPaymentLanguageType value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the resolution of the barcode.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  200;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getDpi()
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p489299_="https://jakarta.ee/xml/ns/jaxb" xmlns:p517109_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p866921_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The border style for separators in between the different parts of the barcode.&#13;
     *                         &lt;ul&gt;&lt;li&gt;none = No separator shall be used.&lt;/li&gt;&lt;li&gt;solidLine = A solid separator line.&lt;/li&gt;&lt;li&gt;solidLineWithScissors = A solid separator line with a scissor icon.&lt;/li&gt;&lt;li&gt;dashedLine = A dashed separator line.&lt;/li&gt;&lt;li&gt;dashedLineWithScissors = A dashed separator line with a scissor icon.&lt;/li&gt;&lt;li&gt;dottedLine = A dotted separator line.&lt;/li&gt;&lt;li&gt;dottedLineWithScissors = A dotted separator line with a scissor icon.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link QrSwissPaymentSeparatorType }
     *     
     */
    public QrSwissPaymentSeparatorType getSeparator() {
        if (separator == null) {
            return QrSwissPaymentSeparatorType.DASHED_LINE_WITH_SCISSORS;
        } else {
            return separator;
        }
    }

    /**
     * Sets the value of the separator property.
     * 
     * @param value
     *     allowed object is
     *     {@link QrSwissPaymentSeparatorType }
     *     
     * @see #getSeparator()
     */
    public void setSeparator(QrSwissPaymentSeparatorType value) {
        this.separator = value;
    }

    public boolean isSetSeparator() {
        return (this.separator!= null);
    }

}
