
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import net.webpdf.wsclient.schema.FileDataType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Allows the private key to be passed (as a PEM file), for decryption of an asymmetrically encrypted document.&#13;
 *                     The transfer of multiple private keys or other structures is not provided for at this point; exactly one private key is expected for decrypting the document.&#13;
 *                     The rights recipient must already be assigned to the document when the document is encrypted. The certificate and private key must therefore be selected in such a way that they map a rights recipient who was entered in this document when it was encrypted.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PrivateKeyFileDataType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PrivateKeyFileDataType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>string">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FileDataGroup"/>
 *       <attribute name="password" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PrivateKeyFileDataType", propOrder = {
    "value"
})
public class PrivateKeyFileDataType
    implements FileDataType<String>
{

    @XmlValue
    protected java.lang.String value;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the private key itself is encrypted (recommended), this password allows read access to the key to make it available for decrypting the document.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "password")
    protected java.lang.String password;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "source")
    protected FileDataSourceType source;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anyURI")
    protected java.lang.String uri;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link java.lang.String }
     *     
     */
    public java.lang.String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link java.lang.String }
     *     
     */
    public void setValue(java.lang.String value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If the private key itself is encrypted (recommended), this password allows read access to the key to make it available for decrypting the document.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link java.lang.String }
     *     
     */
    public java.lang.String getPassword() {
        if (password == null) {
            return "";
        } else {
            return password;
        }
    }

    /**
     * Sets the value of the password property.
     * 
     * @param value
     *     allowed object is
     *     {@link java.lang.String }
     *     
     * @see #getPassword()
     */
    public void setPassword(java.lang.String value) {
        this.password = value;
    }

    public boolean isSetPassword() {
        return (this.password!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Selects the data source for the hereby expressed resource.&#13;
     *                         Possible values are:&#13;
     *                         &lt;ul&gt;&lt;li&gt;value = The element's value shall contain the BASE64 encoded data.&lt;/li&gt;&lt;li&gt;uri = The data shall be located at the given uri.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link FileDataSourceType }
     *     
     */
    public FileDataSourceType getSource() {
        if (source == null) {
            return FileDataSourceType.VALUE;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataSourceType }
     *     
     * @see #getSource()
     */
    public void setSource(FileDataSourceType value) {
        this.source = value;
    }

    public boolean isSetSource() {
        return (this.source!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p931607_="https://jakarta.ee/xml/ns/jaxb" xmlns:p994488_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The uri the data shall be located at. (This shall only have effect, if the "source" is "uri".)&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link java.lang.String }
     *     
     */
    public java.lang.String getUri() {
        if (uri == null) {
            return "";
        } else {
            return uri;
        }
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link java.lang.String }
     *     
     * @see #getUri()
     */
    public void setUri(java.lang.String value) {
        this.uri = value;
    }

    public boolean isSetUri() {
        return (this.uri!= null);
    }

}
