
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select the printing mode, that shall be used.&#13;
 *                     &lt;ul&gt;&lt;li&gt;default = The drawing operations are applied to the printout as defined in the PDF document.&lt;/li&gt;&lt;li&gt;image = Creates an image of a fixed resolution for every page of the document, to guarantee a uniform printing result.&lt;/li&gt;&lt;li&gt;raster = Every page of the document is rastered before printing. This is a compatibility mode for older printers.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PrintModeType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PrintModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="default"/>
 *     <enumeration value="raster"/>
 *     <enumeration value="image"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PrintModeType")
@XmlEnum
public enum PrintModeType {

    @XmlEnumValue("default")
    DEFAULT("default"),
    @XmlEnumValue("raster")
    RASTER("raster"),
    @XmlEnumValue("image")
    IMAGE("image");
    private final String value;

    PrintModeType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PrintModeType fromValue(String v) {
        for (PrintModeType c: PrintModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
