
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Removes one or more documents from the portfolio.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PortfolioRemoveType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PortfolioRemoveType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <choice maxOccurs="unbounded">
 *         <element name="selection" type="{http://schema.webpdf.de/1.0/operation}PortfolioSelectionType"/>
 *       </choice>
 *       <attribute name="initialDocumentPath" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="initialFileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PortfolioRemoveType", propOrder = {
    "selection"
})
public class PortfolioRemoveType {

    protected List<PortfolioSelectionType> selection;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the path/folder where the initially shown document is stored in the portfolio.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The "path" and "fileName" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by "/" separated nested folder names.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialDocumentPath")
    protected String initialDocumentPath;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select the name of the initially shown document.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The "path" and "fileName" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by "/" separated nested folder names.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialFileName")
    protected String initialFileName;

    /**
     * Gets the value of the selection property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the selection property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSelection().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PortfolioSelectionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the selection property.
     */
    public List<PortfolioSelectionType> getSelection() {
        if (selection == null) {
            selection = new ArrayList<>();
        }
        return this.selection;
    }

    public boolean isSetSelection() {
        return ((this.selection!= null)&&(!this.selection.isEmpty()));
    }

    public void unsetSelection() {
        this.selection = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the path/folder where the initially shown document is stored in the portfolio.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The "path" and "fileName" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by "/" separated nested folder names.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInitialDocumentPath() {
        if (initialDocumentPath == null) {
            return "";
        } else {
            return initialDocumentPath;
        }
    }

    /**
     * Sets the value of the initialDocumentPath property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getInitialDocumentPath()
     */
    public void setInitialDocumentPath(String value) {
        this.initialDocumentPath = value;
    }

    public boolean isSetInitialDocumentPath() {
        return (this.initialDocumentPath!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Select the name of the initially shown document.&#13;
     * &#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p33647_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:p514165_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p888768_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Important:&lt;/b&gt;&#13;
     *                         The "path" and "fileName" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by "/" separated nested folder names.&#13;
     *                     &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInitialFileName() {
        if (initialFileName == null) {
            return "";
        } else {
            return initialFileName;
        }
    }

    /**
     * Sets the value of the initialFileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getInitialFileName()
     */
    public void setInitialFileName(String value) {
        this.initialFileName = value;
    }

    public boolean isSetInitialFileName() {
        return (this.initialFileName!= null);
    }

}
