
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p567934_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p643558_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to define whether and in which format the XML report for a successful conversion will be returned.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = An XML report will not be returned&lt;/li&gt;&lt;li&gt;linked = The XML report will be appended at the end of the PDF/A document.&lt;/li&gt;&lt;li&gt;zip = The PDF/A document and the XML report will be packaged together in a ZIP archive.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p567934_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p643558_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
 *                     The format of the document generated with "errorReport" and "successReport" is described by the http://schema.webpdf.de/1.0/report/pdfa.xsd schema.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfaSuccessReportType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PdfaSuccessReportType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="zip"/>
 *     <enumeration value="linked"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfaSuccessReportType")
@XmlEnum
public enum PdfaSuccessReportType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("zip")
    ZIP("zip"),
    @XmlEnumValue("linked")
    LINKED("linked");
    private final String value;

    PdfaSuccessReportType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PdfaSuccessReportType fromValue(String v) {
        for (PdfaSuccessReportType c: PdfaSuccessReportType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
