
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p567934_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p643558_="https://jakarta.ee/xml/ns/jaxb" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This parameter is used to define whether and in which format the XML report for a failed conversion will be returned.&#13;
 *                     &lt;ul&gt;&lt;li&gt;none = An XML report will not be returned&lt;/li&gt;&lt;li&gt;message = The XML report will be returned as part of the error message&lt;/li&gt;&lt;li&gt;file = The XML report will be saved in a file&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for PdfaErrorReportType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="PdfaErrorReportType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="file"/>
 *     <enumeration value="message"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfaErrorReportType")
@XmlEnum
public enum PdfaErrorReportType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("file")
    FILE("file"),
    @XmlEnumValue("message")
    MESSAGE("message");
    private final String value;

    PdfaErrorReportType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static PdfaErrorReportType fromValue(String v) {
        for (PdfaErrorReportType c: PdfaErrorReportType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
