
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The style of transition animation.&#13;
 *                     &lt;ul&gt;&lt;li&gt;blinds = Crossfades&lt;/li&gt;&lt;li&gt;box = Crossfades in a rectangular pattern&lt;/li&gt;&lt;li&gt;cover = Covers&lt;/li&gt;&lt;li&gt;dissolve = Dissolves&lt;/li&gt;&lt;li&gt;fade = Fades&lt;/li&gt;&lt;li&gt;fly = Page flies in&lt;/li&gt;&lt;li&gt;glitter = Page dissolves and is replaced&lt;/li&gt;&lt;li&gt;push = Page is pushed out&lt;/li&gt;&lt;li&gt;split = Splits page&lt;/li&gt;&lt;li&gt;uncover = Uncovers page&lt;/li&gt;&lt;li&gt;wipe = Wipes page&lt;/li&gt;&lt;li&gt;none = No special effect&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OutlineTransitionStyleType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="OutlineTransitionStyleType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="blinds"/>
 *     <enumeration value="box"/>
 *     <enumeration value="cover"/>
 *     <enumeration value="dissolve"/>
 *     <enumeration value="fade"/>
 *     <enumeration value="fly"/>
 *     <enumeration value="glitter"/>
 *     <enumeration value="push"/>
 *     <enumeration value="split"/>
 *     <enumeration value="uncover"/>
 *     <enumeration value="wipe"/>
 *     <enumeration value="none"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OutlineTransitionStyleType")
@XmlEnum
public enum OutlineTransitionStyleType {

    @XmlEnumValue("blinds")
    BLINDS("blinds"),
    @XmlEnumValue("box")
    BOX("box"),
    @XmlEnumValue("cover")
    COVER("cover"),
    @XmlEnumValue("dissolve")
    DISSOLVE("dissolve"),
    @XmlEnumValue("fade")
    FADE("fade"),
    @XmlEnumValue("fly")
    FLY("fly"),
    @XmlEnumValue("glitter")
    GLITTER("glitter"),
    @XmlEnumValue("push")
    PUSH("push"),
    @XmlEnumValue("split")
    SPLIT("split"),
    @XmlEnumValue("uncover")
    UNCOVER("uncover"),
    @XmlEnumValue("wipe")
    WIPE("wipe"),
    @XmlEnumValue("none")
    NONE("none");
    private final String value;

    OutlineTransitionStyleType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static OutlineTransitionStyleType fromValue(String v) {
        for (OutlineTransitionStyleType c: OutlineTransitionStyleType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
