
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The options operation element can be used to change the way documents are displayed.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
 *                     For all hereby contained options, please consult the chapter "Display Options". This is especially important concerning the content format of headers and footers.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OptionsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="OptionsType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <all>
 *         <element name="pageTransitions" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="pageTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="transitionSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionTransitionType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="background" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="colorBackground" type="{http://schema.webpdf.de/1.0/operation}ColorBackgroundType"/>
 *                             <element name="imageBackground" type="{http://schema.webpdf.de/1.0/operation}ImageBackgroundType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="backgroundSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionBackgroundType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="headerFooter" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="headerFooterContent" type="{http://schema.webpdf.de/1.0/operation}HeaderFooterType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="headerFooterSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionHeaderFooterType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="boxes" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="resize">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="boxesResize" type="{http://schema.webpdf.de/1.0/operation}BoxesResizeType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="boxesRemove" type="{http://schema.webpdf.de/1.0/operation}SelectionBoxType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="viewerPreferences" type="{http://schema.webpdf.de/1.0/operation}ViewerPreferencesType" minOccurs="0"/>
 *       </all>
 *       <attribute name="pageLayout" type="{http://schema.webpdf.de/1.0/operation}PageLayoutType" default="singlePage" />
 *       <attribute name="initialView" type="{http://schema.webpdf.de/1.0/operation}InitialViewType" default="none" />
 *       <attribute name="magnification" type="{http://schema.webpdf.de/1.0/operation}MagnificationType" default="fitWidth" />
 *       <attribute name="magnificationZoom" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="6400"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="initialPage" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="language" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OptionsType", propOrder = {
    "pageTransitions",
    "background",
    "headerFooter",
    "boxes",
    "viewerPreferences"
})
public class OptionsType
    extends BaseToolboxType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to change the document's page transition animations. You can use multiple operations of this type in order to define various transitions for various page ranges in a single step.&lt;/p&gt;
     * </pre>
     * 
     */
    protected OptionsType.PageTransitions pageTransitions;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a background layer to the document or removes it (the "add" and "remove" elements are mutually exclusive, i.e., you must select one or the other).&lt;/p&gt;
     * </pre>
     * 
     */
    protected OptionsType.Background background;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a header and footer to the document or removes them (the "add" and "remove" elements are mutually exclusive, i.e., you must select one or the other).&lt;/p&gt;
     * </pre>
     * 
     */
    protected OptionsType.HeaderFooter headerFooter;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to modify the document's boxes.&#13;
     * &#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
     *                                     You can use multiple "resize" or "remove" operations in order to manipulate various boxes simultaneously in a single step.&#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     */
    protected OptionsType.Boxes boxes;
    protected ViewerPreferencesType viewerPreferences;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the page layout when the PDF document is opened.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;singlePage = Individual pages&lt;/li&gt;&lt;li&gt;singlePageContinous = Continuous individual pages&lt;/li&gt;&lt;li&gt;twoPages = Page pairs&lt;/li&gt;&lt;li&gt;twoPagesContinous = Continuous page pairs&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pageLayout")
    protected PageLayoutType pageLayout;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which sub-windows will be opened when the PDF document is opened.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = No special view&lt;/li&gt;&lt;li&gt;outlines = Opens the "Bookmarks" tab&lt;/li&gt;&lt;li&gt;thumbnails = Opens the "Thumbnails" tab&lt;/li&gt;&lt;li&gt;fullscreen = Opens the document in full screen mode&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialView")
    protected InitialViewType initialView;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the zoom settings according to a defined mode.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = Uses the application's default view&lt;/li&gt;&lt;li&gt;fitWidth = Page width&lt;/li&gt;&lt;li&gt;fitPage = Page dimensions&lt;/li&gt;&lt;li&gt;fitHeight = Page height&lt;/li&gt;&lt;li&gt;fitVisible = Page content width&lt;/li&gt;&lt;li&gt;fitActual = Uses the original page dimensions (100% zoom factor)&lt;/li&gt;&lt;li&gt;zoom = Sets an explicit magnification value&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "magnification")
    protected MagnificationType magnification;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the value for zooming.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "magnificationZoom")
    protected Integer magnificationZoom;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the page that will be shown when the document is opened.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "initialPage")
    protected Integer initialPage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the language (and optionally the country) for the content of the document. The value is encoded as RFC 3066 (Tags for the Identification of Languages) and includes either the language only (e.g. "de") or the language and a country identifier (e.g. "de-DE").&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "language")
    protected String language;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to change the document's page transition animations. You can use multiple operations of this type in order to define various transitions for various page ranges in a single step.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.PageTransitions }
     *     
     */
    public OptionsType.PageTransitions getPageTransitions() {
        return pageTransitions;
    }

    /**
     * Sets the value of the pageTransitions property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.PageTransitions }
     *     
     * @see #getPageTransitions()
     */
    public void setPageTransitions(OptionsType.PageTransitions value) {
        this.pageTransitions = value;
    }

    public boolean isSetPageTransitions() {
        return (this.pageTransitions!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a background layer to the document or removes it (the "add" and "remove" elements are mutually exclusive, i.e., you must select one or the other).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.Background }
     *     
     */
    public OptionsType.Background getBackground() {
        return background;
    }

    /**
     * Sets the value of the background property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.Background }
     *     
     * @see #getBackground()
     */
    public void setBackground(OptionsType.Background value) {
        this.background = value;
    }

    public boolean isSetBackground() {
        return (this.background!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a header and footer to the document or removes them (the "add" and "remove" elements are mutually exclusive, i.e., you must select one or the other).&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.HeaderFooter }
     *     
     */
    public OptionsType.HeaderFooter getHeaderFooter() {
        return headerFooter;
    }

    /**
     * Sets the value of the headerFooter property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.HeaderFooter }
     *     
     * @see #getHeaderFooter()
     */
    public void setHeaderFooter(OptionsType.HeaderFooter value) {
        this.headerFooter = value;
    }

    public boolean isSetHeaderFooter() {
        return (this.headerFooter!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Can be used to modify the document's boxes.&#13;
     * &#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
     *                                     You can use multiple "resize" or "remove" operations in order to manipulate various boxes simultaneously in a single step.&#13;
     *                                 &lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.Boxes }
     *     
     */
    public OptionsType.Boxes getBoxes() {
        return boxes;
    }

    /**
     * Sets the value of the boxes property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.Boxes }
     *     
     * @see #getBoxes()
     */
    public void setBoxes(OptionsType.Boxes value) {
        this.boxes = value;
    }

    public boolean isSetBoxes() {
        return (this.boxes!= null);
    }

    /**
     * Gets the value of the viewerPreferences property.
     * 
     * @return
     *     possible object is
     *     {@link ViewerPreferencesType }
     *     
     */
    public ViewerPreferencesType getViewerPreferences() {
        return viewerPreferences;
    }

    /**
     * Sets the value of the viewerPreferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link ViewerPreferencesType }
     *     
     */
    public void setViewerPreferences(ViewerPreferencesType value) {
        this.viewerPreferences = value;
    }

    public boolean isSetViewerPreferences() {
        return (this.viewerPreferences!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the page layout when the PDF document is opened.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;singlePage = Individual pages&lt;/li&gt;&lt;li&gt;singlePageContinous = Continuous individual pages&lt;/li&gt;&lt;li&gt;twoPages = Page pairs&lt;/li&gt;&lt;li&gt;twoPagesContinous = Continuous page pairs&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link PageLayoutType }
     *     
     */
    public PageLayoutType getPageLayout() {
        if (pageLayout == null) {
            return PageLayoutType.SINGLE_PAGE;
        } else {
            return pageLayout;
        }
    }

    /**
     * Sets the value of the pageLayout property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageLayoutType }
     *     
     * @see #getPageLayout()
     */
    public void setPageLayout(PageLayoutType value) {
        this.pageLayout = value;
    }

    public boolean isSetPageLayout() {
        return (this.pageLayout!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines which sub-windows will be opened when the PDF document is opened.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = No special view&lt;/li&gt;&lt;li&gt;outlines = Opens the "Bookmarks" tab&lt;/li&gt;&lt;li&gt;thumbnails = Opens the "Thumbnails" tab&lt;/li&gt;&lt;li&gt;fullscreen = Opens the document in full screen mode&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link InitialViewType }
     *     
     */
    public InitialViewType getInitialView() {
        if (initialView == null) {
            return InitialViewType.NONE;
        } else {
            return initialView;
        }
    }

    /**
     * Sets the value of the initialView property.
     * 
     * @param value
     *     allowed object is
     *     {@link InitialViewType }
     *     
     * @see #getInitialView()
     */
    public void setInitialView(InitialViewType value) {
        this.initialView = value;
    }

    public boolean isSetInitialView() {
        return (this.initialView!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Sets the zoom settings according to a defined mode.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;none = Uses the application's default view&lt;/li&gt;&lt;li&gt;fitWidth = Page width&lt;/li&gt;&lt;li&gt;fitPage = Page dimensions&lt;/li&gt;&lt;li&gt;fitHeight = Page height&lt;/li&gt;&lt;li&gt;fitVisible = Page content width&lt;/li&gt;&lt;li&gt;fitActual = Uses the original page dimensions (100% zoom factor)&lt;/li&gt;&lt;li&gt;zoom = Sets an explicit magnification value&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MagnificationType }
     *     
     */
    public MagnificationType getMagnification() {
        if (magnification == null) {
            return MagnificationType.FIT_WIDTH;
        } else {
            return magnification;
        }
    }

    /**
     * Sets the value of the magnification property.
     * 
     * @param value
     *     allowed object is
     *     {@link MagnificationType }
     *     
     * @see #getMagnification()
     */
    public void setMagnification(MagnificationType value) {
        this.magnification = value;
    }

    public boolean isSetMagnification() {
        return (this.magnification!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the value for zooming.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMagnificationZoom() {
        if (magnificationZoom == null) {
            return  100;
        } else {
            return magnificationZoom;
        }
    }

    /**
     * Sets the value of the magnificationZoom property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getMagnificationZoom()
     */
    public void setMagnificationZoom(int value) {
        this.magnificationZoom = value;
    }

    public boolean isSetMagnificationZoom() {
        return (this.magnificationZoom!= null);
    }

    public void unsetMagnificationZoom() {
        this.magnificationZoom = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Defines the page that will be shown when the document is opened.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getInitialPage() {
        if (initialPage == null) {
            return  1;
        } else {
            return initialPage;
        }
    }

    /**
     * Sets the value of the initialPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getInitialPage()
     */
    public void setInitialPage(int value) {
        this.initialPage = value;
    }

    public boolean isSetInitialPage() {
        return (this.initialPage!= null);
    }

    public void unsetInitialPage() {
        this.initialPage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the language (and optionally the country) for the content of the document. The value is encoded as RFC 3066 (Tags for the Identification of Languages) and includes either the language only (e.g. "de") or the language and a country identifier (e.g. "de-DE").&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLanguage() {
        if (language == null) {
            return "";
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLanguage()
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="colorBackground" type="{http://schema.webpdf.de/1.0/operation}ColorBackgroundType"/>
     *                   <element name="imageBackground" type="{http://schema.webpdf.de/1.0/operation}ImageBackgroundType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="backgroundSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionBackgroundType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "remove"
    })
    public static class Background {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a background image or a solid color background layer to the document (the "colorBackground" and "imageBackground" elements are mutually exclusive, i.e., you must select one or the other). A document is not allowed to have more than one background layer.&lt;/p&gt;
         * </pre>
         * 
         */
        protected OptionsType.Background.Add add;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Removes background layers from all pages of a document. As of this writing, this operation does not have any additional parameters. The "backgroundSelection" element, which must be included without fail, is meant simply as a placeholder for potential future detailed parameters.&lt;/p&gt;
         * </pre>
         * 
         */
        protected OptionsType.Background.Remove remove;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a background image or a solid color background layer to the document (the "colorBackground" and "imageBackground" elements are mutually exclusive, i.e., you must select one or the other). A document is not allowed to have more than one background layer.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.Background.Add }
         *     
         */
        public OptionsType.Background.Add getAdd() {
            return add;
        }

        /**
         * Sets the value of the add property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.Background.Add }
         *     
         * @see #getAdd()
         */
        public void setAdd(OptionsType.Background.Add value) {
            this.add = value;
        }

        public boolean isSetAdd() {
            return (this.add!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Removes background layers from all pages of a document. As of this writing, this operation does not have any additional parameters. The "backgroundSelection" element, which must be included without fail, is meant simply as a placeholder for potential future detailed parameters.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.Background.Remove }
         *     
         */
        public OptionsType.Background.Remove getRemove() {
            return remove;
        }

        /**
         * Sets the value of the remove property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.Background.Remove }
         *     
         * @see #getRemove()
         */
        public void setRemove(OptionsType.Background.Remove value) {
            this.remove = value;
        }

        public boolean isSetRemove() {
            return (this.remove!= null);
        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="colorBackground" type="{http://schema.webpdf.de/1.0/operation}ColorBackgroundType"/>
         *         <element name="imageBackground" type="{http://schema.webpdf.de/1.0/operation}ImageBackgroundType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "colorBackground",
            "imageBackground"
        })
        public static class Add {

            protected ColorBackgroundType colorBackground;
            protected ImageBackgroundType imageBackground;

            /**
             * Gets the value of the colorBackground property.
             * 
             * @return
             *     possible object is
             *     {@link ColorBackgroundType }
             *     
             */
            public ColorBackgroundType getColorBackground() {
                return colorBackground;
            }

            /**
             * Sets the value of the colorBackground property.
             * 
             * @param value
             *     allowed object is
             *     {@link ColorBackgroundType }
             *     
             */
            public void setColorBackground(ColorBackgroundType value) {
                this.colorBackground = value;
            }

            public boolean isSetColorBackground() {
                return (this.colorBackground!= null);
            }

            /**
             * Gets the value of the imageBackground property.
             * 
             * @return
             *     possible object is
             *     {@link ImageBackgroundType }
             *     
             */
            public ImageBackgroundType getImageBackground() {
                return imageBackground;
            }

            /**
             * Sets the value of the imageBackground property.
             * 
             * @param value
             *     allowed object is
             *     {@link ImageBackgroundType }
             *     
             */
            public void setImageBackground(ImageBackgroundType value) {
                this.imageBackground = value;
            }

            public boolean isSetImageBackground() {
                return (this.imageBackground!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="backgroundSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionBackgroundType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "backgroundSelection"
        })
        public static class Remove {

            protected SelectionBackgroundType backgroundSelection;

            /**
             * Gets the value of the backgroundSelection property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionBackgroundType }
             *     
             */
            public SelectionBackgroundType getBackgroundSelection() {
                return backgroundSelection;
            }

            /**
             * Sets the value of the backgroundSelection property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionBackgroundType }
             *     
             */
            public void setBackgroundSelection(SelectionBackgroundType value) {
                this.backgroundSelection = value;
            }

            public boolean isSetBackgroundSelection() {
                return (this.backgroundSelection!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="resize">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="boxesResize" type="{http://schema.webpdf.de/1.0/operation}BoxesResizeType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="boxesRemove" type="{http://schema.webpdf.de/1.0/operation}SelectionBoxType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "resize",
        "remove"
    })
    public static class Boxes {

        protected List<OptionsType.Boxes.Resize> resize;
        protected List<OptionsType.Boxes.Remove> remove;

        /**
         * Gets the value of the resize property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the resize property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getResize().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.Boxes.Resize }
         * </p>
         * 
         * 
         * @return
         *     The value of the resize property.
         */
        public List<OptionsType.Boxes.Resize> getResize() {
            if (resize == null) {
                resize = new ArrayList<>();
            }
            return this.resize;
        }

        public boolean isSetResize() {
            return ((this.resize!= null)&&(!this.resize.isEmpty()));
        }

        public void unsetResize() {
            this.resize = null;
        }

        /**
         * Gets the value of the remove property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the remove property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getRemove().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.Boxes.Remove }
         * </p>
         * 
         * 
         * @return
         *     The value of the remove property.
         */
        public List<OptionsType.Boxes.Remove> getRemove() {
            if (remove == null) {
                remove = new ArrayList<>();
            }
            return this.remove;
        }

        public boolean isSetRemove() {
            return ((this.remove!= null)&&(!this.remove.isEmpty()));
        }

        public void unsetRemove() {
            this.remove = null;
        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="boxesRemove" type="{http://schema.webpdf.de/1.0/operation}SelectionBoxType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "boxesRemove"
        })
        public static class Remove {

            protected SelectionBoxType boxesRemove;

            /**
             * Gets the value of the boxesRemove property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionBoxType }
             *     
             */
            public SelectionBoxType getBoxesRemove() {
                return boxesRemove;
            }

            /**
             * Sets the value of the boxesRemove property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionBoxType }
             *     
             */
            public void setBoxesRemove(SelectionBoxType value) {
                this.boxesRemove = value;
            }

            public boolean isSetBoxesRemove() {
                return (this.boxesRemove!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="boxesResize" type="{http://schema.webpdf.de/1.0/operation}BoxesResizeType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "boxesResize"
        })
        public static class Resize {

            protected BoxesResizeType boxesResize;

            /**
             * Gets the value of the boxesResize property.
             * 
             * @return
             *     possible object is
             *     {@link BoxesResizeType }
             *     
             */
            public BoxesResizeType getBoxesResize() {
                return boxesResize;
            }

            /**
             * Sets the value of the boxesResize property.
             * 
             * @param value
             *     allowed object is
             *     {@link BoxesResizeType }
             *     
             */
            public void setBoxesResize(BoxesResizeType value) {
                this.boxesResize = value;
            }

            public boolean isSetBoxesResize() {
                return (this.boxesResize!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="headerFooterContent" type="{http://schema.webpdf.de/1.0/operation}HeaderFooterType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="headerFooterSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionHeaderFooterType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "remove"
    })
    public static class HeaderFooter {

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a header and footer to the document . A document is not allowed to have more than one header and footer definition.&lt;/p&gt;
         * </pre>
         * 
         */
        protected OptionsType.HeaderFooter.Add add;
        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Removes header and footer definitions from all pages of a document. As of this writing, this operation does not have any additional parameters. The "headerFooterSelection" element, which must be included without fail, is meant simply as a placeholder for potential future detailed parameters.&lt;/p&gt;
         * </pre>
         * 
         */
        protected OptionsType.HeaderFooter.Remove remove;

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Adds a header and footer to the document . A document is not allowed to have more than one header and footer definition.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.HeaderFooter.Add }
         *     
         */
        public OptionsType.HeaderFooter.Add getAdd() {
            return add;
        }

        /**
         * Sets the value of the add property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.HeaderFooter.Add }
         *     
         * @see #getAdd()
         */
        public void setAdd(OptionsType.HeaderFooter.Add value) {
            this.add = value;
        }

        public boolean isSetAdd() {
            return (this.add!= null);
        }

        /**
         * <pre>
         * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Removes header and footer definitions from all pages of a document. As of this writing, this operation does not have any additional parameters. The "headerFooterSelection" element, which must be included without fail, is meant simply as a placeholder for potential future detailed parameters.&lt;/p&gt;
         * </pre>
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.HeaderFooter.Remove }
         *     
         */
        public OptionsType.HeaderFooter.Remove getRemove() {
            return remove;
        }

        /**
         * Sets the value of the remove property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.HeaderFooter.Remove }
         *     
         * @see #getRemove()
         */
        public void setRemove(OptionsType.HeaderFooter.Remove value) {
            this.remove = value;
        }

        public boolean isSetRemove() {
            return (this.remove!= null);
        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="headerFooterContent" type="{http://schema.webpdf.de/1.0/operation}HeaderFooterType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "headerFooterContent"
        })
        public static class Add {

            protected HeaderFooterType headerFooterContent;

            /**
             * Gets the value of the headerFooterContent property.
             * 
             * @return
             *     possible object is
             *     {@link HeaderFooterType }
             *     
             */
            public HeaderFooterType getHeaderFooterContent() {
                return headerFooterContent;
            }

            /**
             * Sets the value of the headerFooterContent property.
             * 
             * @param value
             *     allowed object is
             *     {@link HeaderFooterType }
             *     
             */
            public void setHeaderFooterContent(HeaderFooterType value) {
                this.headerFooterContent = value;
            }

            public boolean isSetHeaderFooterContent() {
                return (this.headerFooterContent!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="headerFooterSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionHeaderFooterType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "headerFooterSelection"
        })
        public static class Remove {

            protected SelectionHeaderFooterType headerFooterSelection;

            /**
             * Gets the value of the headerFooterSelection property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionHeaderFooterType }
             *     
             */
            public SelectionHeaderFooterType getHeaderFooterSelection() {
                return headerFooterSelection;
            }

            /**
             * Sets the value of the headerFooterSelection property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionHeaderFooterType }
             *     
             */
            public void setHeaderFooterSelection(SelectionHeaderFooterType value) {
                this.headerFooterSelection = value;
            }

            public boolean isSetHeaderFooterSelection() {
                return (this.headerFooterSelection!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type</p>.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.</p>
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="pageTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="transitionSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionTransitionType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "remove"
    })
    public static class PageTransitions {

        protected List<OptionsType.PageTransitions.Add> add;
        protected List<OptionsType.PageTransitions.Remove> remove;

        /**
         * Gets the value of the add property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the add property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getAdd().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.PageTransitions.Add }
         * </p>
         * 
         * 
         * @return
         *     The value of the add property.
         */
        public List<OptionsType.PageTransitions.Add> getAdd() {
            if (add == null) {
                add = new ArrayList<>();
            }
            return this.add;
        }

        public boolean isSetAdd() {
            return ((this.add!= null)&&(!this.add.isEmpty()));
        }

        public void unsetAdd() {
            this.add = null;
        }

        /**
         * Gets the value of the remove property.
         * 
         * <p>This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the remove property.</p>
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * </p>
         * <pre>
         * getRemove().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.PageTransitions.Remove }
         * </p>
         * 
         * 
         * @return
         *     The value of the remove property.
         */
        public List<OptionsType.PageTransitions.Remove> getRemove() {
            if (remove == null) {
                remove = new ArrayList<>();
            }
            return this.remove;
        }

        public boolean isSetRemove() {
            return ((this.remove!= null)&&(!this.remove.isEmpty()));
        }

        public void unsetRemove() {
            this.remove = null;
        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="pageTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "pageTransition"
        })
        public static class Add {

            protected TransitionType pageTransition;

            /**
             * Gets the value of the pageTransition property.
             * 
             * @return
             *     possible object is
             *     {@link TransitionType }
             *     
             */
            public TransitionType getPageTransition() {
                return pageTransition;
            }

            /**
             * Sets the value of the pageTransition property.
             * 
             * @param value
             *     allowed object is
             *     {@link TransitionType }
             *     
             */
            public void setPageTransition(TransitionType value) {
                this.pageTransition = value;
            }

            public boolean isSetPageTransition() {
                return (this.pageTransition!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type</p>.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.</p>
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="transitionSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionTransitionType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "transitionSelection"
        })
        public static class Remove {

            protected SelectionTransitionType transitionSelection;

            /**
             * Gets the value of the transitionSelection property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionTransitionType }
             *     
             */
            public SelectionTransitionType getTransitionSelection() {
                return transitionSelection;
            }

            /**
             * Sets the value of the transitionSelection property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionTransitionType }
             *     
             */
            public void setTransitionSelection(SelectionTransitionType value) {
                this.transitionSelection = value;
            }

            public boolean isSetTransitionSelection() {
                return (this.transitionSelection!= null);
            }

        }

    }

}
