
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the font and formatting for the header and footer.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OptionsFontType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="OptionsFontType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="size" default="10">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *             <maxInclusive value="1296"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="underline" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="color" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#000000" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OptionsFontType")
public class OptionsFontType {

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the font that should be used for the text output. If a font is not specified, "Helvetica" will be used.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "name")
    protected String name;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the text size for the text output.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "size")
    protected Integer size;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the text in the header and footer will be underlined.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "underline")
    protected Boolean underline;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the colour for the text output. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "color")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String color;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the name of the font that should be used for the text output. If a font is not specified, "Helvetica" will be used.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        if (name == null) {
            return "";
        } else {
            return name;
        }
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    public void setName(String value) {
        this.name = value;
    }

    public boolean isSetName() {
        return (this.name!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the text size for the text output.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSize() {
        if (size == null) {
            return  10;
        } else {
            return size;
        }
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getSize()
     */
    public void setSize(int value) {
        this.size = value;
    }

    public boolean isSetSize() {
        return (this.size!= null);
    }

    public void unsetSize() {
        this.size = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If true, the text in the header and footer will be underlined.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isUnderline() {
        if (underline == null) {
            return false;
        } else {
            return underline;
        }
    }

    /**
     * Sets the value of the underline property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isUnderline()
     */
    public void setUnderline(boolean value) {
        this.underline = value;
    }

    public boolean isSetUnderline() {
        return (this.underline!= null);
    }

    public void unsetUnderline() {
        this.underline = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p112675_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:p263167_="https://jakarta.ee/xml/ns/jaxb" xmlns:p878401_="urn:jaxb.jvnet.org:plugin:simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the colour for the text output. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColor() {
        if (color == null) {
            return "#000000";
        } else {
            return color;
        }
    }

    /**
     * Sets the value of the color property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getColor()
     */
    public void setColor(String value) {
        this.color = value;
    }

    public boolean isSetColor() {
        return (this.color!= null);
    }

}
