
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import net.webpdf.wsclient.schema.ParameterInterface;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The "OCR" web service can be used to run character recognition in PDF documents or images.&#13;
 *                     If recognition is run on images, they will be converted to PDF documents. More specifically, a page will be generated for each image in the PDF document, with this page containing the original image and a text layer with the recognized text.&#13;
 *                     Character recognition on PDF documents will only work with documents that do not contain text already. Normally, these will be documents that were generated by scanners and that only have an image per page in the PDF document.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for OcrType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="OcrType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <all>
 *         <element name="page" type="{http://schema.webpdf.de/1.0/operation}OcrPageType" minOccurs="0"/>
 *         <element name="pdfa" type="{http://schema.webpdf.de/1.0/operation}PdfaType" minOccurs="0"/>
 *         <element name="optimization" type="{http://schema.webpdf.de/1.0/operation}ImageOptimizationType" minOccurs="0"/>
 *       </all>
 *       <attribute name="language" type="{http://schema.webpdf.de/1.0/operation}OcrLanguageType" default="eng" />
 *       <attribute name="outputFormat" default="pdf">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}OcrOutputType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="checkResolution" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="imageDpi" default="200">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}DpiType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="forceEachPage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="normalizePageRotation" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="failOnWarning" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="jpegQuality" default="75">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="ocrMode" type="{http://schema.webpdf.de/1.0/operation}OcrModeType" default="pageSegments" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OcrType", propOrder = {

})
public class OcrType
    implements ParameterInterface
{

    protected OcrPageType page;
    protected PdfaType pdfa;
    protected ImageOptimizationType optimization;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the "special characters" of the respective language (e.g. "üäö" in German) can be recognized better. At present, the following languages are supported:&#13;
     *                         &lt;ul&gt;&lt;li&gt;eng = English&lt;/li&gt;&lt;li&gt;fra = French&lt;/li&gt;&lt;li&gt;spa = Spanish&lt;/li&gt;&lt;li&gt;deu = German&lt;/li&gt;&lt;li&gt;ita = Italian&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "language")
    protected OcrLanguageType language;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).&#13;
     *                         &lt;ul&gt;&lt;li&gt;text = Text&lt;/li&gt;&lt;li&gt;hocr = XML (hOCR)&lt;/li&gt;&lt;li&gt;pdf = PDF&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "outputFormat")
    protected OcrOutputType outputFormat;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," then the DPI resolution of the output file will be checked. Resolutions of less than 200 DPI are rejected in this check because as a rule, they do not produce good results for character recognition.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "checkResolution")
    protected Boolean checkResolution;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the minimum resolution images will be embedded with in resulting PDF documents. When a value of 0 is set for this parameter, the images shall be embedded using resolutions and dimensions as close as possible to the original source images.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "imageDpi")
    protected Integer imageDpi;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If a PDF document contains text content on any page, the web service will refuse to run character recognition again. If, however, a value of "true" is passed for this option, all the pages in the document will be considered individually and character recognition will be run on all pages that do not contain text (layers) so that a new layer with text will be generated for them.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "forceEachPage")
    protected Boolean forceEachPage;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then, for the recognition of a rotated text, the system will attempt to rotate the page in such a way that the text in the document will not appear to be rotated and will be shown "upright."&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "normalizePageRotation")
    protected Boolean normalizePageRotation;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", character recognition will fail even in the event of warnings that do not prevent recognition, but that make it very unlikely for a meaningful result to be generated.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "failOnWarning")
    protected Boolean failOnWarning;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A percentage that sets the compression ratio and influences the quality of JPEG images, that shall be embedded in resulting PDF documents. Higher values will result in less compressed images of higher quality.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "jpegQuality")
    protected Integer jpegQuality;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the mode used to find structured text on the pages. Depending on which mode is chosen, different requirements are set for the text and different assumptions are made about the text.&#13;
     *                         &lt;ul&gt;&lt;li&gt;pageSegments = The text on the page is clearly structured and decomposable into clear paragraphs and layout segments. Overlapping of text elements/lines does not occur. Headings and thus texts with deviating text sizes and font set, could be present.&lt;/li&gt;&lt;li&gt;column = The text is arranged on the pages in several, more or less uniform columns, next to each other. Font and text size are mostly uniform.&lt;/li&gt;&lt;li&gt;unfiltered = No assumptions are made about the text, any letters that can be found are recognized as such, regardless of whether they can be assigned to a text column, or line, or even a word. Font size and typeface can vary absolutely and texts are not necessarily arranged in clearly recognizable columns or according to a fixed layout. Texts and lines can overlap. (This mode usually recognizes more text (especially with more complex layouts), but usually also generates the most error detections, since no result is sorted out due to its deviation from the norm.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "ocrMode")
    protected OcrModeType ocrMode;

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link OcrPageType }
     *     
     */
    public OcrPageType getPage() {
        return page;
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrPageType }
     *     
     */
    public void setPage(OcrPageType value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    /**
     * Gets the value of the pdfa property.
     * 
     * @return
     *     possible object is
     *     {@link PdfaType }
     *     
     */
    public PdfaType getPdfa() {
        return pdfa;
    }

    /**
     * Sets the value of the pdfa property.
     * 
     * @param value
     *     allowed object is
     *     {@link PdfaType }
     *     
     */
    public void setPdfa(PdfaType value) {
        this.pdfa = value;
    }

    public boolean isSetPdfa() {
        return (this.pdfa!= null);
    }

    /**
     * Gets the value of the optimization property.
     * 
     * @return
     *     possible object is
     *     {@link ImageOptimizationType }
     *     
     */
    public ImageOptimizationType getOptimization() {
        return optimization;
    }

    /**
     * Sets the value of the optimization property.
     * 
     * @param value
     *     allowed object is
     *     {@link ImageOptimizationType }
     *     
     */
    public void setOptimization(ImageOptimizationType value) {
        this.optimization = value;
    }

    public boolean isSetOptimization() {
        return (this.optimization!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify the language for the output document (PDF/image). The language must be defined for the character recognition operation (OCR) so that the "special characters" of the respective language (e.g. "üäö" in German) can be recognized better. At present, the following languages are supported:&#13;
     *                         &lt;ul&gt;&lt;li&gt;eng = English&lt;/li&gt;&lt;li&gt;fra = French&lt;/li&gt;&lt;li&gt;spa = Spanish&lt;/li&gt;&lt;li&gt;deu = German&lt;/li&gt;&lt;li&gt;ita = Italian&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OcrLanguageType }
     *     
     */
    public OcrLanguageType getLanguage() {
        if (language == null) {
            return OcrLanguageType.ENG;
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrLanguageType }
     *     
     * @see #getLanguage()
     */
    public void setLanguage(OcrLanguageType value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Different output formats can be created during character recognition. Generally, the document is generated as a PDF document, but the output can also be as an ASCII document or an XML document if desired (HOCR).&#13;
     *                         &lt;ul&gt;&lt;li&gt;text = Text&lt;/li&gt;&lt;li&gt;hocr = XML (hOCR)&lt;/li&gt;&lt;li&gt;pdf = PDF&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OcrOutputType }
     *     
     */
    public OcrOutputType getOutputFormat() {
        if (outputFormat == null) {
            return OcrOutputType.PDF;
        } else {
            return outputFormat;
        }
    }

    /**
     * Sets the value of the outputFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrOutputType }
     *     
     * @see #getOutputFormat()
     */
    public void setOutputFormat(OcrOutputType value) {
        this.outputFormat = value;
    }

    public boolean isSetOutputFormat() {
        return (this.outputFormat!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true," then the DPI resolution of the output file will be checked. Resolutions of less than 200 DPI are rejected in this check because as a rule, they do not produce good results for character recognition.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCheckResolution() {
        if (checkResolution == null) {
            return true;
        } else {
            return checkResolution;
        }
    }

    /**
     * Sets the value of the checkResolution property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isCheckResolution()
     */
    public void setCheckResolution(boolean value) {
        this.checkResolution = value;
    }

    public boolean isSetCheckResolution() {
        return (this.checkResolution!= null);
    }

    public void unsetCheckResolution() {
        this.checkResolution = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to set the minimum resolution images will be embedded with in resulting PDF documents. When a value of 0 is set for this parameter, the images shall be embedded using resolutions and dimensions as close as possible to the original source images.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getImageDpi() {
        if (imageDpi == null) {
            return  200;
        } else {
            return imageDpi;
        }
    }

    /**
     * Sets the value of the imageDpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getImageDpi()
     */
    public void setImageDpi(int value) {
        this.imageDpi = value;
    }

    public boolean isSetImageDpi() {
        return (this.imageDpi!= null);
    }

    public void unsetImageDpi() {
        this.imageDpi = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If a PDF document contains text content on any page, the web service will refuse to run character recognition again. If, however, a value of "true" is passed for this option, all the pages in the document will be considered individually and character recognition will be run on all pages that do not contain text (layers) so that a new layer with text will be generated for them.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isForceEachPage() {
        if (forceEachPage == null) {
            return false;
        } else {
            return forceEachPage;
        }
    }

    /**
     * Sets the value of the forceEachPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isForceEachPage()
     */
    public void setForceEachPage(boolean value) {
        this.forceEachPage = value;
    }

    public boolean isSetForceEachPage() {
        return (this.forceEachPage!= null);
    }

    public void unsetForceEachPage() {
        this.forceEachPage = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", then, for the recognition of a rotated text, the system will attempt to rotate the page in such a way that the text in the document will not appear to be rotated and will be shown "upright."&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isNormalizePageRotation() {
        if (normalizePageRotation == null) {
            return false;
        } else {
            return normalizePageRotation;
        }
    }

    /**
     * Sets the value of the normalizePageRotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isNormalizePageRotation()
     */
    public void setNormalizePageRotation(boolean value) {
        this.normalizePageRotation = value;
    }

    public boolean isSetNormalizePageRotation() {
        return (this.normalizePageRotation!= null);
    }

    public void unsetNormalizePageRotation() {
        this.normalizePageRotation = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;If "true", character recognition will fail even in the event of warnings that do not prevent recognition, but that make it very unlikely for a meaningful result to be generated.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFailOnWarning() {
        if (failOnWarning == null) {
            return false;
        } else {
            return failOnWarning;
        }
    }

    /**
     * Sets the value of the failOnWarning property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isFailOnWarning()
     */
    public void setFailOnWarning(boolean value) {
        this.failOnWarning = value;
    }

    public boolean isSetFailOnWarning() {
        return (this.failOnWarning!= null);
    }

    public void unsetFailOnWarning() {
        this.failOnWarning = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;A percentage that sets the compression ratio and influences the quality of JPEG images, that shall be embedded in resulting PDF documents. Higher values will result in less compressed images of higher quality.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getJpegQuality() {
        if (jpegQuality == null) {
            return  75;
        } else {
            return jpegQuality;
        }
    }

    /**
     * Sets the value of the jpegQuality property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getJpegQuality()
     */
    public void setJpegQuality(int value) {
        this.jpegQuality = value;
    }

    public boolean isSetJpegQuality() {
        return (this.jpegQuality!= null);
    }

    public void unsetJpegQuality() {
        this.jpegQuality = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p740872_="https://jakarta.ee/xml/ns/jaxb" xmlns:p755783_="urn:jaxb.jvnet.org:plugin:inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Specifies the mode used to find structured text on the pages. Depending on which mode is chosen, different requirements are set for the text and different assumptions are made about the text.&#13;
     *                         &lt;ul&gt;&lt;li&gt;pageSegments = The text on the page is clearly structured and decomposable into clear paragraphs and layout segments. Overlapping of text elements/lines does not occur. Headings and thus texts with deviating text sizes and font set, could be present.&lt;/li&gt;&lt;li&gt;column = The text is arranged on the pages in several, more or less uniform columns, next to each other. Font and text size are mostly uniform.&lt;/li&gt;&lt;li&gt;unfiltered = No assumptions are made about the text, any letters that can be found are recognized as such, regardless of whether they can be assigned to a text column, or line, or even a word. Font size and typeface can vary absolutely and texts are not necessarily arranged in clearly recognizable columns or according to a fixed layout. Texts and lines can overlap. (This mode usually recognizes more text (especially with more complex layouts), but usually also generates the most error detections, since no result is sorted out due to its deviation from the norm.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OcrModeType }
     *     
     */
    public OcrModeType getOcrMode() {
        if (ocrMode == null) {
            return OcrModeType.PAGE_SEGMENTS;
        } else {
            return ocrMode;
        }
    }

    /**
     * Sets the value of the ocrMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link OcrModeType }
     *     
     * @see #getOcrMode()
     */
    public void setOcrMode(OcrModeType value) {
        this.ocrMode = value;
    }

    public boolean isSetOcrMode() {
        return (this.ocrMode!= null);
    }

}
