
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The move operation element can be used to change the order of the document's pages.&lt;/p&gt;
 * </pre>
 * 
 * <p>Java class for MoveType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="MoveType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <attribute name="mode" type="{http://schema.webpdf.de/1.0/operation}MoveModeType" default="afterPage" />
 *       <attribute name="targetPosition" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="1" />
 *       <attribute name="order" type="{http://schema.webpdf.de/1.0/operation}OrderType" default="preserve" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MoveType")
public class MoveType
    extends BaseToolboxType
{

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected page range should be inserted before or after the selected position in the document.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;afterPage = After the selected position.&lt;/li&gt;&lt;li&gt;beforePage = Before the selected position.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "mode")
    protected MoveModeType mode;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the page number after or before which the selected page range should be inserted. This page must not be part of the page range being moved.&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "targetPosition")
    protected Integer targetPosition;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define which page(s) should be moved. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9").&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "pages")
    protected String pages;
    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the order of the selected pages at the new position.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;preserve = Keeps the original order in which the pages were found in the document.&lt;/li&gt;&lt;li&gt;reverse = Reverses the original order in which the pages were found in the document.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     */
    @XmlAttribute(name = "order")
    protected OrderType order;

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to specify whether the selected page range should be inserted before or after the selected position in the document.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;afterPage = After the selected position.&lt;/li&gt;&lt;li&gt;beforePage = Before the selected position.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link MoveModeType }
     *     
     */
    public MoveModeType getMode() {
        if (mode == null) {
            return MoveModeType.AFTER_PAGE;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MoveModeType }
     *     
     * @see #getMode()
     */
    public void setMode(MoveModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the page number after or before which the selected page range should be inserted. This page must not be part of the page range being moved.&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getTargetPosition() {
        if (targetPosition == null) {
            return  1;
        } else {
            return targetPosition;
        }
    }

    /**
     * Sets the value of the targetPosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getTargetPosition()
     */
    public void setTargetPosition(int value) {
        this.targetPosition = value;
    }

    public boolean isSetTargetPosition() {
        return (this.targetPosition!= null);
    }

    public void unsetTargetPosition() {
        this.targetPosition = null;
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to define which page(s) should be moved. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., "1,5-6,9").&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "1";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPages()
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:q1="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;Used to select the order of the selected pages at the new position.&#13;
     *                                 &lt;ul&gt;&lt;li&gt;preserve = Keeps the original order in which the pages were found in the document.&lt;/li&gt;&lt;li&gt;reverse = Reverses the original order in which the pages were found in the document.&lt;/li&gt;&lt;/ul&gt;&lt;/p&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link OrderType }
     *     
     */
    public OrderType getOrder() {
        if (order == null) {
            return OrderType.PRESERVE;
        } else {
            return order;
        }
    }

    /**
     * Sets the value of the order property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrderType }
     *     
     * @see #getOrder()
     */
    public void setOrder(OrderType value) {
        this.order = value;
    }

    public boolean isSetOrder() {
        return (this.order!= null);
    }

}
